/*
 * Decompiled with CFR 0.152.
 */
package genepi.io.shapeit;

import genepi.io.shapeit.ShapeitHap;
import java.io.BufferedWriter;
import java.io.File;
import java.io.FileWriter;
import java.io.IOException;

public class ShapeitHapsWriter {
    private BufferedWriter bw;
    private boolean first = true;

    public ShapeitHapsWriter(String filename) throws IOException {
        this.bw = new BufferedWriter(new FileWriter(new File(filename), false));
        this.first = true;
    }

    public void write(ShapeitHap hap) throws IOException {
        if (this.first) {
            this.first = false;
        } else {
            this.bw.newLine();
        }
        StringBuilder haps = new StringBuilder();
        for (int i : hap.getHaps()) {
            haps.append(" ");
            haps.append(i);
        }
        this.bw.write(hap.getChromosome() + " " + hap.getSnp() + " " + hap.getPosition() + " " + hap.getFirstAllele() + " " + hap.getSecondAllele() + haps);
    }

    public void close() throws IOException {
        this.bw.close();
    }
}

