/*
 * Decompiled with CFR 0.152.
 */
package genepi.io.table.reader;

import genepi.io.table.exceptions.ColumnNotFoundException;
import genepi.io.table.reader.ITableReader;
import genepi.io.table.reader.Row;
import genepi.io.table.reader.RowIterator;
import java.util.Iterator;

public abstract class AbstractTableReader
implements ITableReader {
    @Override
    public int getInteger(String column) {
        if (this.hasColumn(column)) {
            return this.getInteger(this.getColumnIndex(column));
        }
        throw new ColumnNotFoundException("Column '" + column + "' not available");
    }

    @Override
    public String getString(String column) {
        if (this.hasColumn(column)) {
            return this.getString(this.getColumnIndex(column));
        }
        throw new ColumnNotFoundException("Column '" + column + "' not available");
    }

    @Override
    public double getDouble(String column) {
        if (this.hasColumn(column)) {
            return this.getDouble(this.getColumnIndex(column));
        }
        throw new ColumnNotFoundException("Column '" + column + "' not available");
    }

    @Override
    public double getDouble(int column) {
        return Double.parseDouble(this.getRow()[column]);
    }

    @Override
    public int getInteger(int column) {
        return Integer.parseInt(this.getRow()[column]);
    }

    @Override
    public String getString(int column) {
        return this.getRow()[column];
    }

    @Override
    public Iterator<Row> iterator() {
        return new RowIterator(this);
    }

    @Override
    public Row getAsObject() {
        return new Row(this);
    }
}

