/*
 * Decompiled with CFR 0.152.
 */
package genepi.io.table.reader;

import au.com.bytecode.opencsv.CSVReader;
import genepi.io.table.reader.AbstractTableReader;
import java.io.DataInputStream;
import java.io.FileReader;
import java.io.IOException;
import java.io.InputStreamReader;
import java.util.HashMap;
import java.util.Map;

public class CsvTableReader
extends AbstractTableReader {
    private String[] header;
    private String[] currentLine;
    private Map<String, Integer> columns2Index = new HashMap<String, Integer>();
    private CSVReader reader;
    private String filename;

    public CsvTableReader(String filename, char seperator) {
        this.filename = filename;
        try {
            this.reader = new CSVReader(new FileReader(filename), seperator);
            this.header = this.reader.readNext();
            while (this.header != null && this.header[0].startsWith("#")) {
                this.header = this.reader.readNext();
            }
            if (this.header != null) {
                for (int i = 0; i < this.header.length; ++i) {
                    this.columns2Index.put(this.header[i].toLowerCase().trim(), i);
                }
            }
        }
        catch (IOException e) {
            e.printStackTrace();
        }
    }

    public CsvTableReader(String filename, char seperator, boolean ignoreComment) {
        this.filename = filename;
        try {
            this.reader = new CSVReader(new FileReader(filename), seperator);
            this.header = this.reader.readNext();
            if (this.header != null) {
                for (int i = 0; i < this.header.length; ++i) {
                    this.columns2Index.put(this.header[i].toLowerCase().trim(), i);
                }
            }
        }
        catch (IOException e) {
            e.printStackTrace();
        }
    }

    public CsvTableReader(DataInputStream in, char seperator) {
        try {
            this.reader = new CSVReader(new InputStreamReader(in), seperator);
            this.header = this.reader.readNext();
            while (this.header != null && this.header[0].startsWith("#")) {
                this.header = this.reader.readNext();
            }
            if (this.header != null) {
                for (int i = 0; i < this.header.length; ++i) {
                    this.columns2Index.put(this.header[i].toLowerCase().trim(), i);
                }
            }
        }
        catch (IOException e) {
            e.printStackTrace();
        }
    }

    public CsvTableReader(String filename, char seperator, int offset) {
        this.filename = filename;
        try {
            int i;
            this.reader = new CSVReader(new FileReader(filename), seperator);
            this.header = this.reader.readNext();
            while (this.header[0].startsWith("#")) {
                this.header = this.reader.readNext();
            }
            String[] newHeader = new String[this.header.length + offset];
            for (i = 0; i < offset + this.header.length; ++i) {
                newHeader[i] = i < offset ? "test_" + i : this.header[i - offset];
            }
            this.header = newHeader;
            for (i = 0; i < this.header.length; ++i) {
                this.columns2Index.put(this.header[i].toLowerCase().trim(), i);
            }
        }
        catch (IOException e) {
            e.printStackTrace();
        }
    }

    @Override
    public int getColumnIndex(String column) {
        return this.columns2Index.get(column.toLowerCase().trim());
    }

    @Override
    public boolean hasColumn(String column) {
        return this.columns2Index.containsKey(column.toLowerCase().trim());
    }

    @Override
    public String[] getColumns() {
        return this.header;
    }

    @Override
    public String[] getRow() {
        return this.currentLine;
    }

    @Override
    public boolean next() {
        try {
            this.currentLine = this.reader.readNext();
            while (this.currentLine != null && this.currentLine[0].startsWith("#")) {
                this.currentLine = this.reader.readNext();
            }
            return this.currentLine != null;
        }
        catch (IOException e) {
            e.printStackTrace();
            return false;
        }
    }

    @Override
    public void close() {
        try {
            this.reader.close();
        }
        catch (IOException e) {
            e.printStackTrace();
        }
    }

    public String toString() {
        return this.filename;
    }
}

