/*
 * Decompiled with CFR 0.152.
 */
package genepi.io.table.reader;

import genepi.io.table.reader.AbstractTableReader;
import java.io.File;
import java.io.IOException;
import java.util.HashMap;
import java.util.Map;
import jxl.NumberCell;
import jxl.Sheet;
import jxl.Workbook;
import jxl.read.biff.BiffException;

public class ExcelTableReader
extends AbstractTableReader {
    private String[] header;
    private Sheet sheet;
    private Workbook workbook;
    private Map<String, Integer> columns2Index = new HashMap<String, Integer>();
    private int currentRow;
    private int columnCount;
    private String[] currentLine;
    private String filename;

    public ExcelTableReader(String filename) {
        this.filename = filename;
        try {
            this.workbook = Workbook.getWorkbook((File)new File(filename));
            this.sheet = this.workbook.getSheet(0);
            this.columnCount = this.sheet.getColumns();
            this.header = new String[this.columnCount];
            for (int i = 0; i < this.columnCount; ++i) {
                this.header[i] = this.sheet.getCell(i, 0).getContents().trim();
                this.columns2Index.put(this.header[i].toLowerCase(), i);
            }
            this.currentRow = 0;
        }
        catch (BiffException e) {
            e.printStackTrace();
        }
        catch (IOException e) {
            e.printStackTrace();
        }
    }

    @Override
    public int getColumnIndex(String column) {
        return this.columns2Index.get(column.toLowerCase().trim());
    }

    @Override
    public boolean hasColumn(String column) {
        return this.columns2Index.containsKey(column.toLowerCase().trim());
    }

    @Override
    public String[] getColumns() {
        return this.header;
    }

    @Override
    public String[] getRow() {
        return this.currentLine;
    }

    @Override
    public double getDouble(int column) {
        return ((NumberCell)this.sheet.getCell(column, this.currentRow)).getValue();
    }

    @Override
    public boolean next() {
        ++this.currentRow;
        if (this.currentRow < this.sheet.getRows()) {
            while (this.sheet.getCell(0, this.currentRow).isHidden() && this.currentRow < this.sheet.getRows()) {
                ++this.currentRow;
                if (this.currentRow < this.sheet.getRows()) continue;
                return false;
            }
            this.currentLine = new String[this.columnCount];
            for (int i = 0; i < this.columnCount; ++i) {
                this.currentLine[i] = this.sheet.getCell(i, this.currentRow).getContents();
            }
            return true;
        }
        return false;
    }

    @Override
    public void close() {
        this.workbook.close();
    }

    public String toString() {
        return this.filename;
    }
}

