/*
 * Decompiled with CFR 0.152.
 */
package genepi.io.table.writer;

import au.com.bytecode.opencsv.CSVWriter;
import genepi.io.table.writer.AbstractTableWriter;
import java.io.FileWriter;
import java.io.IOException;
import java.io.Writer;
import java.util.HashMap;
import java.util.Map;

public class CsvTableWriter
extends AbstractTableWriter {
    private CSVWriter writer;
    public String[] currentLine;
    private Map<String, Integer> columns2Index = new HashMap<String, Integer>();

    public CsvTableWriter(String filename) {
        try {
            this.writer = new CSVWriter(new FileWriter(filename));
        }
        catch (IOException e) {
            e.printStackTrace();
        }
    }

    public CsvTableWriter(String filename, char separator) {
        try {
            this.writer = new CSVWriter(new FileWriter(filename), separator);
        }
        catch (IOException e) {
            e.printStackTrace();
        }
    }

    public CsvTableWriter(String filename, char separator, boolean quote) {
        try {
            this.writer = new CSVWriter((Writer)new FileWriter(filename), separator, quote ? (char)'\"' : '\u0000', '\u0000');
        }
        catch (IOException e) {
            e.printStackTrace();
        }
    }

    @Override
    public void close() {
        try {
            this.writer.close();
        }
        catch (IOException e) {
            e.printStackTrace();
        }
    }

    @Override
    public int getColumnIndex(String column) {
        return this.columns2Index.get(column);
    }

    @Override
    public boolean next() {
        this.writer.writeNext(this.currentLine);
        for (int i = 0; i < this.currentLine.length; ++i) {
            this.currentLine[i] = "";
        }
        return true;
    }

    @Override
    public void setColumns(String[] columns) {
        this.currentLine = new String[columns.length];
        for (int i = 0; i < columns.length; ++i) {
            this.columns2Index.put(columns[i], i);
            this.currentLine[i] = "";
        }
        this.writer.writeNext(columns);
    }

    @Override
    public void setDouble(int column, double value) {
        this.currentLine[column] = value + "";
    }

    @Override
    public void setInteger(int column, int value) {
        this.currentLine[column] = value + "";
    }

    @Override
    public void setString(int column, String value) {
        this.currentLine[column] = value;
    }

    @Override
    public void setRow(String[] row) {
        this.currentLine = row;
    }
}

