/*
 * Decompiled with CFR 0.152.
 */
package genepi.io.table.writer;

import genepi.io.table.writer.AbstractTableWriter;
import java.io.File;
import java.io.IOException;
import java.util.HashMap;
import java.util.Map;
import jxl.CellView;
import jxl.Workbook;
import jxl.format.CellFormat;
import jxl.write.Label;
import jxl.write.Number;
import jxl.write.WritableCell;
import jxl.write.WritableCellFormat;
import jxl.write.WritableFont;
import jxl.write.WritableSheet;
import jxl.write.WritableWorkbook;
import jxl.write.WriteException;
import jxl.write.biff.RowsExceededException;

public class ExcelTableWriter
extends AbstractTableWriter {
    private WritableWorkbook workbook;
    private WritableSheet sheet;
    private Object[] currentLine;
    private int row = 1;
    private Map<String, Integer> columns2Index = new HashMap<String, Integer>();

    public ExcelTableWriter(String filename) {
        try {
            this.workbook = Workbook.createWorkbook((File)new File(filename));
        }
        catch (IOException e) {
            e.printStackTrace();
        }
        this.sheet = this.workbook.createSheet("Table", 0);
    }

    @Override
    public void close() {
        try {
            for (int i = 0; i < this.currentLine.length; ++i) {
                CellView c = new CellView();
                c.setAutosize(true);
                this.sheet.setColumnView(i, c);
            }
            this.workbook.write();
            this.workbook.close();
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    @Override
    public int getColumnIndex(String column) {
        return this.columns2Index.get(column);
    }

    @Override
    public boolean next() {
        for (int i = 0; i < this.currentLine.length; ++i) {
            if (this.currentLine[i] != null) {
                try {
                    if (this.currentLine[i] instanceof String) {
                        this.sheet.addCell((WritableCell)new Label(i, this.row, this.currentLine[i].toString()));
                    }
                    if (this.currentLine[i] instanceof Double) {
                        this.sheet.addCell((WritableCell)new Number(i, this.row, ((Double)this.currentLine[i]).doubleValue()));
                    }
                    if (this.currentLine[i] instanceof Integer) {
                        this.sheet.addCell((WritableCell)new Number(i, this.row, (double)((Integer)this.currentLine[i]).intValue()));
                    }
                }
                catch (RowsExceededException e) {
                    e.printStackTrace();
                }
                catch (WriteException e) {
                    e.printStackTrace();
                }
            }
            this.currentLine[i] = null;
        }
        ++this.row;
        return true;
    }

    @Override
    public void setColumns(String[] columns) {
        WritableFont font = new WritableFont(WritableFont.ARIAL, 10, WritableFont.BOLD, false);
        WritableCellFormat fontFormat = new WritableCellFormat(font);
        this.currentLine = new Object[columns.length];
        for (int i = 0; i < columns.length; ++i) {
            this.columns2Index.put(columns[i], i);
            this.currentLine[i] = null;
            try {
                this.sheet.addCell((WritableCell)new Label(i, 0, columns[i], (CellFormat)fontFormat));
                continue;
            }
            catch (RowsExceededException e) {
                e.printStackTrace();
                continue;
            }
            catch (WriteException e) {
                e.printStackTrace();
            }
        }
        this.row = 1;
    }

    @Override
    public void setDouble(int column, double value) {
        this.currentLine[column] = value;
    }

    @Override
    public void setInteger(int column, int value) {
        this.currentLine[column] = value;
    }

    @Override
    public void setString(int column, String value) {
        this.currentLine[column] = value;
    }

    @Override
    public void setRow(String[] row) {
        this.currentLine = row;
    }
}

