/*
 * Decompiled with CFR 0.152.
 */
package genepi.io.vcf;

import genepi.io.table.reader.IReader;
import genepi.io.vcf.SnpAlias;
import java.io.BufferedReader;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStreamReader;
import java.util.Iterator;
import java.util.zip.GZIPInputStream;

public class SnpAliasReader
implements IReader<SnpAlias> {
    private String filename;
    private BufferedReader in;
    private String line;
    private SnpAlias currentSnpAlias;

    public SnpAliasReader(String filename) {
        this.filename = filename;
        try {
            this.in = new BufferedReader(new InputStreamReader(new GZIPInputStream(new FileInputStream(filename))));
        }
        catch (IOException e) {
            e.printStackTrace();
        }
    }

    @Override
    public boolean next() throws IOException {
        this.line = this.in.readLine();
        while (this.line != null && this.line.startsWith("#")) {
            this.line = this.in.readLine();
        }
        if (this.line != null) {
            if (!this.line.trim().isEmpty()) {
                try {
                    this.currentSnpAlias = new SnpAlias(this.line);
                }
                catch (Exception e) {
                    System.out.println(this.line);
                    return this.next();
                }
            } else {
                return false;
            }
        }
        return this.line != null;
    }

    @Override
    public void close() {
        try {
            this.in.close();
        }
        catch (IOException e) {
            e.printStackTrace();
        }
    }

    @Override
    public SnpAlias get() {
        return this.currentSnpAlias;
    }

    @Override
    public Iterator<SnpAlias> iterator() {
        return null;
    }

    @Override
    public void reset() {
    }

    public String getFilename() {
        return this.filename;
    }
}

