/*
 * Decompiled with CFR 0.152.
 */
package genepi.io.vcf;

import genepi.io.table.reader.IReader;
import genepi.io.vcf.Variation;
import java.io.BufferedReader;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStreamReader;
import java.util.Iterator;
import java.util.zip.GZIPInputStream;

public class VariationReader
implements IReader<Variation> {
    private String filename;
    private BufferedReader in;
    private String line;
    private Variation currentVariation;

    public VariationReader(String filename) {
        this.filename = filename;
        try {
            this.in = new BufferedReader(new InputStreamReader(new GZIPInputStream(new FileInputStream(filename))));
        }
        catch (IOException e) {
            e.printStackTrace();
        }
    }

    @Override
    public boolean next() throws IOException {
        this.line = this.in.readLine();
        while (this.line != null && this.line.startsWith("#")) {
            this.line = this.in.readLine();
        }
        if (this.line != null) {
            this.currentVariation = new Variation(this.line);
        }
        return this.line != null;
    }

    @Override
    public void close() {
        try {
            this.in.close();
        }
        catch (IOException e) {
            e.printStackTrace();
        }
    }

    @Override
    public Variation get() {
        return this.currentVariation;
    }

    @Override
    public Iterator<Variation> iterator() {
        return null;
    }

    @Override
    public void reset() {
    }

    public String getFilename() {
        return this.filename;
    }
}

