/*
 * Decompiled with CFR 0.152.
 */
package qualityAssurance;

import core.TestSample;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import net.sf.json.JSONArray;
import net.sf.json.JsonConfig;
import phylotree.Phylotree;
import qualityAssurance.RuleSet;
import qualityAssurance.issues.QualityFatal;
import qualityAssurance.issues.QualityIssue;
import qualityAssurance.rules.HaplogrepRule;

public class QualityAssistent {
    Collection<TestSample> sampleToCheck;
    RuleSet rules;
    HashMap<TestSample, ArrayList<QualityIssue>> allQualityIssuesLookup = new HashMap();
    HashMap<Integer, QualityIssue> issueLookup = new HashMap();
    HashMap<String, ArrayList<QualityIssue>> issueGroupLookup = new HashMap();
    ArrayList<QualityIssue> allQualityIssues = new ArrayList();
    Phylotree usedPhyloTree = null;
    int numIssues = 0;
    int numIssuedWarnings = 0;
    int numIssuedErrors = 0;

    public QualityAssistent(Collection<TestSample> fileToCheck, RuleSet usedRules, Phylotree usedPhyloTree) {
        this.sampleToCheck = fileToCheck;
        this.rules = usedRules;
        this.usedPhyloTree = usedPhyloTree;
    }

    public void reevaluateRules() {
        for (int i = 0; i < 10; ++i) {
            ArrayList<HaplogrepRule> rulesLevel = this.rules.getRulesLevel(i);
            HashMap allPolys = new HashMap();
            if (rulesLevel == null) continue;
            for (TestSample currentSample : this.sampleToCheck) {
                if (this.allQualityIssuesLookup.get(currentSample) != null && this.allQualityIssuesLookup.get(currentSample).size() != 0) continue;
                for (HaplogrepRule currentRule : rulesLevel) {
                    currentRule.evaluate(this, currentSample);
                }
                for (HaplogrepRule currentRule : rulesLevel) {
                    currentRule.suppressIssues(this, currentSample);
                }
            }
        }
    }

    public void clearAllIssues() {
        for (TestSample currentSample : this.sampleToCheck) {
            this.removeAllIssuesOfSample(currentSample);
        }
    }

    public void addNewIssue(QualityIssue newIssue) {
        if (!this.allQualityIssuesLookup.containsKey(newIssue.getSampleOfIssue())) {
            this.allQualityIssuesLookup.put(newIssue.getSampleOfIssue(), new ArrayList());
        }
        this.allQualityIssuesLookup.get(newIssue.getSampleOfIssue()).add(newIssue);
        this.issueLookup.put(newIssue.getIssueID(), newIssue);
    }

    public void removeIssue(QualityIssue issue) {
        this.allQualityIssuesLookup.remove(issue.getSampleOfIssue());
        this.issueLookup.remove(issue.getIssueID());
    }

    public void removeAllIssuesOfSample(TestSample sample) {
        if (this.allQualityIssuesLookup.containsKey(sample)) {
            for (QualityIssue currentIssue : this.allQualityIssuesLookup.get(sample)) {
                this.issueLookup.remove(currentIssue.getIssueID());
            }
            this.allQualityIssuesLookup.get(sample).clear();
        }
    }

    public Phylotree getUsedPhyloTree() {
        return this.usedPhyloTree;
    }

    public void incNumWarnings() {
        ++this.numIssuedWarnings;
    }

    public void decNumWarnings() {
        --this.numIssuedWarnings;
    }

    public void incNumErrors() {
        ++this.numIssuedErrors;
    }

    public void decNumErrors() {
        --this.numIssuedErrors;
    }

    public int getNumIssuedWarnings() {
        return this.numIssuedWarnings;
    }

    public int getNumIssuedErrors() {
        return this.numIssuedErrors;
    }

    public int getNumIssuedWarnings(TestSample sample) {
        int numWarningsPerSample = 0;
        if (this.allQualityIssuesLookup.get(sample) != null) {
            for (QualityIssue currentIssue : this.allQualityIssuesLookup.get(sample)) {
                if (currentIssue.getPriority() != 0 || currentIssue.isSuppress()) continue;
                ++numWarningsPerSample;
            }
        }
        return numWarningsPerSample;
    }

    public int getNumIssuedErrors(TestSample sample) {
        int numErrorsPerSample = 0;
        if (this.allQualityIssuesLookup.get(sample) != null) {
            for (QualityIssue currentIssue : this.allQualityIssuesLookup.get(sample)) {
                if (currentIssue.getPriority() != 1 || currentIssue.isSuppress()) continue;
                ++numErrorsPerSample;
            }
        }
        return numErrorsPerSample;
    }

    public QualityIssue getIssue(TestSample sample, String desc) {
        if (this.allQualityIssuesLookup.get(sample) != null) {
            for (QualityIssue currentIssue : this.allQualityIssuesLookup.get(sample)) {
                if (!currentIssue.getDescription().contains(desc)) continue;
                return currentIssue;
            }
        }
        return null;
    }

    public String toString() {
        String s = "Quality Issues: \n";
        for (QualityIssue currentIssue : this.issueLookup.values()) {
            if (currentIssue.isSuppress()) continue;
            s = s + currentIssue + "\n";
        }
        return s;
    }

    public int getNewIssueID() {
        ++this.numIssues;
        return this.numIssues;
    }

    public JSONArray getAllIssuesJSON() {
        JsonConfig conf = new JsonConfig();
        conf.setExcludes(new String[]{"sampleOfIssue"});
        ArrayList<QualityIssue> notSuppressedIssues = new ArrayList<QualityIssue>();
        for (QualityIssue currentIssue : this.issueLookup.values()) {
            if (currentIssue.isSuppress()) continue;
            notSuppressedIssues.add(currentIssue);
        }
        JSONArray jsonArray = JSONArray.fromObject(notSuppressedIssues, (JsonConfig)conf);
        return jsonArray;
    }

    public ArrayList<QualityIssue> getAllRecomb() {
        ArrayList<QualityIssue> notSuppressedIssues = new ArrayList<QualityIssue>();
        for (QualityIssue currentIssue : this.issueLookup.values()) {
            if (currentIssue.getPriority() <= 1 || currentIssue.isSuppress()) continue;
            notSuppressedIssues.add(currentIssue);
        }
        return notSuppressedIssues;
    }

    public JSONArray getSampleIssues(TestSample testSample) {
        ArrayList<QualityIssue> sampleQualityIssues = new ArrayList<QualityIssue>();
        if (this.allQualityIssuesLookup.containsKey(testSample)) {
            for (QualityIssue currentIssue : this.allQualityIssuesLookup.get(testSample)) {
                if (currentIssue.isSuppress()) continue;
                sampleQualityIssues.add(currentIssue);
            }
        }
        JsonConfig conf = new JsonConfig();
        conf.setExcludes(new String[]{"sampleOfIssue"});
        JSONArray jsonArray = JSONArray.fromObject(sampleQualityIssues, (JsonConfig)conf);
        return jsonArray;
    }

    public QualityIssue doCorrection(int issueID, int correctionMethodID) {
        QualityIssue issueToCorrect = this.issueLookup.get(issueID);
        if (issueToCorrect != null) {
            issueToCorrect.doAutoCorrection(this, correctionMethodID);
            this.removeIssue(issueToCorrect);
        }
        return issueToCorrect;
    }

    public QualityIssue getIssueByID(int issueID) {
        return this.issueLookup.get(issueID);
    }

    public void reevaluateRulesForSample(TestSample sampleToReevaluate) {
        this.removeAllIssuesOfSample(sampleToReevaluate);
        for (int i = 0; i < 10; ++i) {
            ArrayList<HaplogrepRule> rulesLevel = this.rules.getRulesLevel(i);
            if (rulesLevel == null || this.allQualityIssuesLookup.get(sampleToReevaluate) != null && this.allQualityIssuesLookup.get(sampleToReevaluate).size() != 0) continue;
            for (HaplogrepRule currentRule : rulesLevel) {
                currentRule.evaluate(this, sampleToReevaluate);
            }
            for (HaplogrepRule currentRule : rulesLevel) {
                currentRule.suppressIssues(this, sampleToReevaluate);
            }
        }
    }

    public ArrayList<QualityIssue> getIssues(TestSample sample) {
        return this.allQualityIssuesLookup.get(sample);
    }

    public boolean hasFatalIssues(TestSample currentTestSample) {
        if (!this.allQualityIssuesLookup.containsKey(currentTestSample)) {
            return false;
        }
        for (QualityIssue currentIssue : this.allQualityIssuesLookup.get(currentTestSample)) {
            if (currentIssue.isSuppress() || !(currentIssue instanceof QualityFatal)) continue;
            return true;
        }
        return false;
    }
}

