/*
 * Decompiled with CFR 0.152.
 */
package qualityAssurance.issues.errors;

import core.Polymorphism;
import core.TestSample;
import java.util.ArrayList;
import qualityAssurance.CorrectionMethod;
import qualityAssurance.QualityAssistent;
import qualityAssurance.issues.IssueType;
import qualityAssurance.issues.QualityFatal;
import qualityAssurance.issues.QualityIssue;

public class CustomOrCompleteRangeDetected
extends QualityFatal {
    public CustomOrCompleteRangeDetected(QualityAssistent assistent, TestSample sampleOfIssue) {
        super(assistent, sampleOfIssue, "Complete or custom range recognized", IssueType.RANGE);
        this.correctionMethods.add(new SetCompleteRange(this.correctionMethods.size(), (QualityIssue)this));
        this.correctionMethods.add(new SetCustomRange(this.correctionMethods.size(), (QualityIssue)this));
    }

    @Override
    public ArrayList<CorrectionMethod> getChildren() {
        return this.correctionMethods;
    }

    public void executeCorrectionMethodeByID(TestSample testSample, int methodID) {
        ((CorrectionMethod)this.correctionMethods.get(methodID)).execute(testSample);
    }

    class SetCustomRange
    extends CorrectionMethod {
        public SetCustomRange(int methodID, QualityIssue issue) {
            super("Create custom range", methodID, issue);
        }

        @Override
        public void execute(TestSample testSample) {
            testSample.getSample().getSampleRanges().clear();
            for (Polymorphism poly : testSample.getSample().getPolymorphisms()) {
                testSample.getSample().getSampleRanges().addCustomRange(poly.getPosition(), poly.getPosition());
            }
        }
    }

    class SetCompleteRange
    extends CorrectionMethod {
        public SetCompleteRange(int methodID, QualityIssue issue) {
            super("Change sample range to complete region", methodID, issue);
        }

        @Override
        public void execute(TestSample testSample) {
            testSample.getSample().getSampleRanges().clear();
            testSample.getSample().getSampleRanges().addCompleteRange();
        }
    }
}

