/*
 * Decompiled with CFR 0.152.
 */
package qualityAssurance.issues.errors;

import core.TestSample;
import java.util.ArrayList;
import qualityAssurance.CorrectionMethod;
import qualityAssurance.QualityAssistent;
import qualityAssurance.issues.IssueType;
import qualityAssurance.issues.QualityFatal;
import qualityAssurance.issues.QualityIssue;

public class MetaboRangeDetected
extends QualityFatal {
    public MetaboRangeDetected(QualityAssistent assistent, TestSample sampleOfIssue) {
        super(assistent, sampleOfIssue, "MetaboChip range detected but does not match the indicated range", IssueType.RANGE);
        this.correctionMethods.add(new SetMataboRange(this.correctionMethods.size(), (QualityIssue)this));
    }

    @Override
    public ArrayList<CorrectionMethod> getChildren() {
        return this.correctionMethods;
    }

    public void executeCorrectionMethodeByID(TestSample testSample, int methodID) {
        ((CorrectionMethod)this.correctionMethods.get(methodID)).execute(testSample);
    }

    class SetMataboRange
    extends CorrectionMethod {
        public SetMataboRange(int methodID, QualityIssue issue) {
            super("Change to metabo chip sample range", methodID, issue);
        }

        @Override
        public void execute(TestSample testSample) {
            testSample.getSample().getSampleRanges().clear();
            testSample.getSample().getSampleRanges().addMetaboChipRange();
        }
    }
}

