/*
 * Decompiled with CFR 0.152.
 */
package qualityAssurance.issues.errors;

import core.Haplogroup;
import core.TestSample;
import java.util.ArrayList;
import qualityAssurance.CorrectionMethod;
import qualityAssurance.QualityAssistent;
import qualityAssurance.issues.IssueType;
import qualityAssurance.issues.QualityIssue;
import qualityAssurance.issues.QualityWarning;

public class NewGroupDetected
extends QualityWarning {
    Haplogroup remainingHaplogroup;
    double remainingQuality;

    public NewGroupDetected(QualityAssistent assistent, TestSample sampleOfIssue, Haplogroup remainingHaplogroup, double remainingQuality) {
        super(assistent, sampleOfIssue, "New haplogroup detected", IssueType.RECOMB2);
        this.remainingHaplogroup = remainingHaplogroup;
        this.remainingQuality = remainingQuality;
    }

    @Override
    public ArrayList<CorrectionMethod> getChildren() {
        return this.correctionMethods;
    }

    public void executeCorrectionMethodeByID(TestSample testSample, int methodID) {
        ((CorrectionMethod)this.correctionMethods.get(methodID)).execute(testSample);
    }

    @Override
    public String toString() {
        String result = "New Group detected  Sample " + this.getSampleOfIssue().getSampleID() + " - Remaining hg: " + this.remainingHaplogroup + " with quality " + this.remainingQuality + "\r\n";
        return result;
    }

    @Override
    public String getDescription() {
        return this.toString();
    }

    class SetMataboRange
    extends CorrectionMethod {
        public SetMataboRange(int methodID, QualityIssue issue) {
            super("New haplogroup detected", methodID, issue);
        }

        @Override
        public void execute(TestSample testSample) {
            testSample.getSample().getSampleRanges().clear();
            testSample.getSample().getSampleRanges().addMetaboChipRange();
        }
    }
}

