/*
 * Decompiled with CFR 0.152.
 */
package qualityAssurance.issues.errors;

import core.Haplogroup;
import core.TestSample;
import java.util.ArrayList;
import qualityAssurance.QualityAssistent;
import qualityAssurance.issues.IssueType;
import qualityAssurance.issues.QualityWarning;

public class RecombinationIssue
extends QualityWarning {
    int distanceToReference = 0;
    ArrayList<Haplogroup> referenceHaplogroups = null;
    ArrayList<Haplogroup> currentSampleHaplogroups = null;
    private String customRanges;

    public RecombinationIssue(QualityAssistent assistent, TestSample sampleOfIssue, int distanceToReference, ArrayList<Haplogroup> referenceHaplogroups, ArrayList<Haplogroup> currentSampleHaplogroups, String string) {
        super(assistent, sampleOfIssue, "Possible recombination: ", IssueType.RECOMB1);
        this.distanceToReference = distanceToReference;
        this.referenceHaplogroups = referenceHaplogroups;
        this.currentSampleHaplogroups = currentSampleHaplogroups;
        this.customRanges = string;
    }

    @Override
    public String getDescription() {
        return this.toString();
    }

    @Override
    public String toString() {
        int i;
        String result = "Possible recombination:  - Distance to reference: \t" + this.distanceToReference + "\t";
        result = result + " HG [Reference \t";
        for (i = 0; i < this.referenceHaplogroups.size(); ++i) {
            result = result + this.referenceHaplogroups.get(i) + "  ";
        }
        result = result + "\t ] [Sample \t";
        for (i = 0; i < this.currentSampleHaplogroups.size(); ++i) {
            result = result + this.currentSampleHaplogroups.get(i) + " ";
        }
        if (this.customRanges != null) {
            result = result + "\t]\t " + this.customRanges + " ";
        }
        return result;
    }
}

