/*
 * Decompiled with CFR 0.152.
 */
package qualityAssurance.rules;

import core.Haplogroup;
import core.TestSample;
import qualityAssurance.QualityAssistent;
import qualityAssurance.issues.IssueType;
import qualityAssurance.issues.QualityFatal;
import qualityAssurance.issues.QualityWarning;
import qualityAssurance.rules.HaplogrepRule;

public class CheckExpectedHGMatchesDetectedHG
extends HaplogrepRule {
    public CheckExpectedHGMatchesDetectedHG(int priority) {
        super(priority);
    }

    @Override
    public void evaluate(QualityAssistent qualityAssistent, TestSample currentSample) {
        if (currentSample.getExpectedHaplogroup().equals(new Haplogroup(""))) {
            return;
        }
        if (currentSample.getResults().size() != 0) {
            Haplogroup detectedHg = currentSample.getResults().get(0).getHaplogroup();
            if (!currentSample.getExpectedHaplogroup().equals(detectedHg)) {
                if (!currentSample.getExpectedHaplogroup().isSuperHaplogroup(qualityAssistent.getUsedPhyloTree(), detectedHg)) {
                    qualityAssistent.addNewIssue(new QualityFatal(qualityAssistent, currentSample, "The expected haplogroup " + currentSample.getExpectedHaplogroup() + " is no super group of the detected haplogroup " + detectedHg, IssueType.QUAL));
                } else {
                    qualityAssistent.addNewIssue(new QualityWarning(qualityAssistent, currentSample, "The detected haplogroup " + detectedHg + " does not match the expected haplogroup " + currentSample.getExpectedHaplogroup() + " but represents a valid sub haplogroup", IssueType.QUAL));
                }
            }
        }
    }

    @Override
    public void suppressIssues(QualityAssistent qualityAssistent, TestSample currentSample) {
    }
}

