/*
 * Decompiled with CFR 0.152.
 */
package qualityAssurance.rules;

import core.Polymorphism;
import core.SampleRanges;
import core.TestSample;
import java.util.ArrayList;
import qualityAssurance.QualityAssistent;
import qualityAssurance.issues.QualityIssue;
import qualityAssurance.issues.errors.ControlRangeDetected;
import qualityAssurance.issues.errors.CustomOrCompleteRangeDetected;
import qualityAssurance.issues.errors.MetaboRangeDetected;
import qualityAssurance.rules.HaplogrepRule;

public class CheckForSampleRange
extends HaplogrepRule {
    ArrayList<Polymorphism> foundReferencePolys = new ArrayList();
    boolean isMetaboChip = true;

    public CheckForSampleRange(int priority) {
        super(priority);
    }

    @Override
    public void evaluate(QualityAssistent qualityAssistent, TestSample currentSample) {
        this.isMetaboChip = true;
        SampleRanges metaboChipRange = new SampleRanges();
        metaboChipRange.addMetaboChipRange();
        for (Polymorphism currentPoly : currentSample.getSample().getPolymorphisms()) {
            if (metaboChipRange.contains(currentPoly)) continue;
            this.isMetaboChip = false;
            break;
        }
        boolean isControlRange = false;
        if (!this.isMetaboChip) {
            isControlRange = true;
            SampleRanges controlRange = new SampleRanges();
            controlRange.addControlRange();
            for (Polymorphism currentPoly : currentSample.getSample().getPolymorphisms()) {
                if (controlRange.contains(currentPoly)) continue;
                isControlRange = false;
                break;
            }
        }
        boolean isCompleteRange = false;
        if (!this.isMetaboChip && !isControlRange) {
            isCompleteRange = true;
        }
        if (this.isMetaboChip && !currentSample.getSample().getSampleRanges().isMataboChipRange()) {
            qualityAssistent.addNewIssue(new MetaboRangeDetected(qualityAssistent, currentSample));
        } else if (isControlRange && !currentSample.getSample().getSampleRanges().isControlRange()) {
            qualityAssistent.addNewIssue(new ControlRangeDetected(qualityAssistent, currentSample));
        } else if (isCompleteRange && !currentSample.getSample().getSampleRanges().isCompleteRange() && !currentSample.getSample().getSampleRanges().isCustomRange()) {
            qualityAssistent.addNewIssue(new CustomOrCompleteRangeDetected(qualityAssistent, currentSample));
        } else {
            currentSample.setReachedQualityLevel(this.getPriority() + 1);
        }
    }

    @Override
    public void suppressIssues(QualityAssistent qualityAssistent, TestSample currentSample) {
        if (this.isMetaboChip) {
            QualityIssue issue = qualityAssistent.getIssue(currentSample, "Common rCRS polymorphim (263G 8860G or 15326G)");
            if (issue != null) {
                issue.setSuppress(true);
            }
            if ((issue = qualityAssistent.getIssue(currentSample, "common RSRS polymorphims found!")) != null) {
                issue.setSuppress(true);
            }
        }
    }
}

