/*
 * Decompiled with CFR 0.152.
 */
package search;

import core.Haplogroup;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import org.json.JSONArray;
import org.json.JSONException;
import org.json.JSONObject;
import search.ranking.results.RankedResult;

public class ClusteredSearchResults {
    private ArrayList<ArrayList<RankedResult>> cluster = new ArrayList();
    private HashMap<Haplogroup, ArrayList<RankedResult>> clusterLookup = new HashMap();

    public ClusteredSearchResults(List<RankedResult> unclusteredResults) {
        int i = -1;
        double currentRank = -100.0;
        ArrayList<RankedResult> currentCluster = null;
        for (RankedResult currentResult : unclusteredResults) {
            if (i == 200) break;
            if (currentRank != currentResult.getDistance()) {
                ++i;
                currentRank = currentResult.getDistance();
                currentCluster = new ArrayList<RankedResult>();
                this.cluster.add(currentCluster);
                this.clusterLookup.put(currentResult.getHaplogroup(), currentCluster);
                currentCluster.add(currentResult);
                continue;
            }
            currentCluster.add(currentResult);
        }
    }

    public JSONArray toJSON() {
        JSONArray resultArray = null;
        resultArray = new JSONArray();
        int rank = 1;
        for (ArrayList<RankedResult> currentCluster : this.cluster) {
            try {
                JSONObject resultObject = this.getClusterAsJSON(currentCluster);
                resultObject.put("pos", rank);
                resultArray.put(resultObject);
                ++rank;
            }
            catch (JSONException e) {
                e.printStackTrace();
            }
        }
        return resultArray;
    }

    private JSONObject getClusterAsJSON(ArrayList<RankedResult> cluster) throws JSONException {
        JSONObject child = new JSONObject();
        JSONObject child1 = new JSONObject();
        JSONArray a = new JSONArray();
        int i = 1;
        for (RankedResult currentResult : cluster) {
            if (i == 1) {
                child.put("iconCls", "icon-treegrid");
                child.put("expanded", true);
                if (cluster.size() == 1) {
                    child.put("leaf", true);
                } else {
                    child.put("leaf", false);
                }
                currentResult.attachToJsonObject(child);
            } else {
                child1 = new JSONObject();
                child1.put("pos", "");
                child1.put("iconCls", "icon-treegridSW");
                child1.put("leaf", true);
                currentResult.attachToJsonObject(child1);
                a.put(child1);
            }
            ++i;
        }
        child.put("children", a);
        return child;
    }

    public ArrayList<RankedResult> getCluster(Haplogroup haplogroup) {
        return this.clusterLookup.get(haplogroup);
    }
}

