/*
 * Decompiled with CFR 0.152.
 */
package search;

import core.Haplogroup;
import core.Polymorphism;
import java.io.Serializable;
import java.util.ArrayList;
import phylotree.PhyloTreeNode;

public class SearchResultTreeNode
implements Serializable {
    private static final long serialVersionUID = 2832456003542749389L;
    private PhyloTreeNode phylotreeNode;
    private ArrayList<Polymorphism> expectedPolys = new ArrayList();
    private ArrayList<Polymorphism> foundPolys = new ArrayList();
    private ArrayList<Polymorphism> notInRangePolys = new ArrayList();
    private ArrayList<Polymorphism> correctedBackmutation = new ArrayList();

    SearchResultTreeNode(PhyloTreeNode treeNode) {
        this.phylotreeNode = treeNode;
    }

    public boolean equals(Object other) {
        if (!(other instanceof SearchResultTreeNode)) {
            return false;
        }
        if (!this.arrayEqualsHelper(this.expectedPolys, ((SearchResultTreeNode)other).expectedPolys)) {
            return false;
        }
        if (!this.arrayEqualsHelper(this.foundPolys, ((SearchResultTreeNode)other).foundPolys)) {
            return false;
        }
        return this.arrayEqualsHelper(this.notInRangePolys, ((SearchResultTreeNode)other).notInRangePolys);
    }

    void addExpectedPoly(Polymorphism polyToAdd) {
        this.expectedPolys.add(polyToAdd);
    }

    void addFoundPoly(Polymorphism polyToAdd) {
        this.foundPolys.add(polyToAdd);
    }

    void addNotInRangePoly(Polymorphism polyToAdd) {
        this.notInRangePolys.add(polyToAdd);
    }

    public Haplogroup getHaplogroup() {
        return this.phylotreeNode.getHaplogroup();
    }

    public ArrayList<Polymorphism> getExpectedPolys() {
        return this.expectedPolys;
    }

    public ArrayList<Polymorphism> getFoundPolys() {
        return this.foundPolys;
    }

    public ArrayList<Polymorphism> getNotInRangePolys() {
        return this.notInRangePolys;
    }

    public ArrayList<Polymorphism> getCorrectedBackmutation() {
        return this.correctedBackmutation;
    }

    void addCorrectedBackmutation(Polymorphism polyToAdd) {
        this.correctedBackmutation.add(polyToAdd);
    }

    private boolean arrayEqualsHelper(ArrayList<Polymorphism> a1, ArrayList<Polymorphism> a2) {
        for (Polymorphism currentPoly : a1) {
            if (a2.contains(currentPoly) || currentPoly.isBackMutation()) continue;
            return false;
        }
        return true;
    }

    public PhyloTreeNode getPhyloTreeNode() {
        return this.phylotreeNode;
    }
}

