/*
 * Decompiled with CFR 0.152.
 */
package search.ranking;

import core.TestSample;
import java.util.ArrayList;
import search.SearchResult;
import search.ranking.results.RankedResult;

public abstract class RankingMethod {
    ArrayList<RankedResult> results;
    int maxTopResults = Integer.MAX_VALUE;
    String name;

    public abstract void setResults(TestSample var1, ArrayList<SearchResult> var2);

    public RankingMethod() {
        this.results = new ArrayList();
    }

    RankingMethod(int maxTopResults) {
        this.maxTopResults = maxTopResults;
        this.results = new ArrayList();
    }

    RankingMethod(int maxTopResults, String name) {
        this.maxTopResults = maxTopResults;
        this.results = new ArrayList();
        this.name = name;
    }

    public String getName() {
        return this.name;
    }

    public void setName(String name) {
        this.name = name;
    }

    public RankedResult getTopResult() {
        return this.results.get(0);
    }

    public ArrayList<RankedResult> getResults() {
        return this.results;
    }

    void cutResultSetToTopHits(TestSample sample) {
        ArrayList<RankedResult> topResults = new ArrayList<RankedResult>();
        int numResults = 0;
        for (RankedResult currentResult : this.results) {
            if (numResults < this.maxTopResults) {
                topResults.add(currentResult);
            } else if (currentResult.getHaplogroup().equals(sample.getExpectedHaplogroup())) {
                topResults.add(currentResult);
            }
            ++numResults;
        }
        this.results = topResults;
    }

    public abstract RankingMethod clone();
}

