/*
 * Decompiled with CFR 0.152.
 */
package search.ranking.results;

import core.Haplogroup;
import java.text.DecimalFormat;
import java.text.DecimalFormatSymbols;
import java.util.Locale;
import org.json.JSONException;
import org.json.JSONObject;
import search.SearchResult;
import search.ranking.results.RankedResult;

public class HammingResult
extends RankedResult {
    private double hammingDistance = this.calcDistance();

    public HammingResult(SearchResult result, Haplogroup expectedHaplogroup) {
        super(result, expectedHaplogroup);
    }

    @Override
    public int compareTo(RankedResult o) {
        int delta = (int)Math.signum(this.hammingDistance - ((HammingResult)o).hammingDistance);
        if (delta == 0) {
            return super.compareTo(o);
        }
        return delta;
    }

    private double calcDistance() {
        double temp = 0.0;
        if (this.searchResult.getWeightRemainingPolys() > 0.0) {
            temp = this.searchResult.getWeightRemainingPolys();
        }
        return temp + this.searchResult.getSumMissingPhyloWeight();
    }

    @Override
    public double getDistance() {
        return this.hammingDistance;
    }

    @Override
    public void attachToJsonObject(JSONObject child) throws JSONException {
        DecimalFormat df = new DecimalFormat("0.000", new DecimalFormatSymbols(Locale.US));
        child.put("rank", df.format(this.hammingDistance));
        if (this.searchResult.getSumMissingPhyloWeight() > 0.0) {
            child.put("rankHG", df.format(this.searchResult.getSumMissingPhyloWeight()));
        } else {
            child.put("rankHG", df.format(new Double(0.0)));
        }
        if (this.searchResult.getWeightRemainingPolys() > 0.0) {
            child.put("rankS", df.format(this.searchResult.getWeightRemainingPolys()));
        } else {
            child.put("rankS", df.format(new Double(0.0)));
        }
        child.put("name", this.searchResult.getHaplogroup().toString());
        child.put("id", this.searchResult.getHaplogroup().toString());
    }
}

