/*
 * Decompiled with CFR 0.152.
 */
package search.ranking.results;

import core.Haplogroup;
import java.text.DecimalFormat;
import java.text.DecimalFormatSymbols;
import java.util.Locale;
import org.json.JSONException;
import org.json.JSONObject;
import search.SearchResult;
import search.ranking.results.RankedResult;

public class JaccardResult
extends RankedResult {
    private double jaccardDistance = this.calcDistance();

    public JaccardResult(SearchResult phyloSearchData, Haplogroup expectedHaplogroup) {
        super(phyloSearchData, expectedHaplogroup);
    }

    @Override
    public int compareTo(RankedResult o) {
        int delta = (int)Math.signum(((JaccardResult)o).jaccardDistance - this.jaccardDistance);
        if (delta == 0) {
            delta = super.compareTo(o);
        }
        return delta;
    }

    private double calcDistance() {
        if (this.getCorrectPolyInTestSample() > 0.0 && this.getAllPoly() > 0.0) {
            return this.getCorrectPolyInTestSample() / this.getAllPoly();
        }
        return 0.0;
    }

    private double getCorrectPolyInTestSample() {
        return this.searchResult.getWeightFoundPolys();
    }

    private double getAllPoly() {
        return this.searchResult.getSumMissingPhyloWeight() + this.searchResult.getSumWeightsAllPolysSample();
    }

    @Override
    public double getDistance() {
        return this.jaccardDistance;
    }

    @Override
    public void attachToJsonObject(JSONObject child) throws JSONException {
        DecimalFormat df = new DecimalFormat("0.000", new DecimalFormatSymbols(Locale.US));
        child.put("rank", df.format(this.jaccardDistance));
        child.put("name", this.searchResult.getHaplogroup().toString());
        child.put("id", this.searchResult.getHaplogroup().toString());
        if (Double.isNaN(this.getCorrectPolyInTestSample())) {
            child.put("rankHG", "-");
        } else {
            child.put("rankHG", df.format(this.getCorrectPolyInTestSample()));
        }
        if (Double.isNaN(this.getAllPoly())) {
            child.put("rankS", "-");
        } else {
            child.put("rankS", df.format(this.getAllPoly()));
        }
    }
}

