/*
 * Decompiled with CFR 0.152.
 */
package com.intel.gkl.compression;

import com.intel.gkl.compression.IntelDeflater;
import htsjdk.samtools.util.zip.DeflaterFactory;
import java.io.File;
import java.util.zip.Deflater;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;

public class IntelDeflaterFactory
extends DeflaterFactory {
    private static final Logger logger = LogManager.getLogger(IntelDeflaterFactory.class);
    private boolean intelDeflaterSupported;

    public IntelDeflaterFactory(File tmpDir) {
        this.intelDeflaterSupported = new IntelDeflater().load(tmpDir);
    }

    public IntelDeflaterFactory() {
        this(null);
    }

    @Override
    public Deflater makeDeflater(int compressionLevel, boolean gzipCompatible) {
        if (this.intelDeflaterSupported && (compressionLevel == 1 && gzipCompatible || compressionLevel != 1)) {
            return new IntelDeflater(compressionLevel, gzipCompatible);
        }
        logger.warn("IntelDeflater is not supported, using Java.util.zip.Deflater");
        return new Deflater(compressionLevel, gzipCompatible);
    }

    public boolean usingIntelDeflater() {
        return this.intelDeflaterSupported;
    }
}

