/*
 * Decompiled with CFR 0.152.
 */
package com.intel.gkl.pairhmm;

import com.intel.gkl.IntelGKLUtils;
import com.intel.gkl.NativeLibraryLoader;
import java.io.File;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.broadinstitute.gatk.nativebindings.pairhmm.HaplotypeDataHolder;
import org.broadinstitute.gatk.nativebindings.pairhmm.PairHMMNativeArguments;
import org.broadinstitute.gatk.nativebindings.pairhmm.PairHMMNativeBinding;
import org.broadinstitute.gatk.nativebindings.pairhmm.ReadDataHolder;

public class IntelPairHmm
implements PairHMMNativeBinding {
    private static final Logger logger = LogManager.getLogger(IntelPairHmm.class);
    private static final String NATIVE_LIBRARY_NAME = "gkl_pairhmm";
    private String nativeLibraryName = "gkl_pairhmm";
    private IntelGKLUtils gklUtils = new IntelGKLUtils();
    boolean useFpga = false;
    boolean useOmp = false;

    void setNativeLibraryName(String nativeLibraryName) {
        this.nativeLibraryName = nativeLibraryName;
    }

    public IntelPairHmm() {
        this.setNativeLibraryName(NATIVE_LIBRARY_NAME);
    }

    @Override
    public synchronized boolean load(File tempDir) {
        boolean isLoaded = this.gklUtils.load(null);
        if (!isLoaded) {
            logger.warn("Intel GKL Utils not loaded");
            return false;
        }
        if (!this.gklUtils.isAvxSupported()) {
            return false;
        }
        return NativeLibraryLoader.load(tempDir, this.nativeLibraryName);
    }

    @Override
    public void initialize(PairHMMNativeArguments args) {
        if (args == null) {
            args = new PairHMMNativeArguments();
            args.useDoublePrecision = false;
            args.maxNumberOfThreads = 1;
        }
        if (!this.useFpga && this.gklUtils.isAvx512Supported()) {
            logger.info("Using CPU-supported AVX-512 instructions");
        }
        if (args.useDoublePrecision && this.useFpga) {
            logger.warn("FPGA PairHMM does not support double precision floating-point. Using AVX PairHMM");
        }
        if (!this.gklUtils.getFlushToZero()) {
            logger.warn("Flush-to-zero (FTZ) is enabled when running PairHMM");
        }
        IntelPairHmm.initNative(ReadDataHolder.class, HaplotypeDataHolder.class, args.useDoublePrecision, args.maxNumberOfThreads, this.useFpga);
        int reqThreads = args.maxNumberOfThreads;
        if (this.useOmp) {
            int availThreads = this.gklUtils.getAvailableOmpThreads();
            int maxThreads = Math.min(reqThreads, availThreads);
            logger.info("Available threads: " + availThreads);
            logger.info("Requested threads: " + reqThreads);
            if (reqThreads > availThreads) {
                logger.warn("Using " + maxThreads + " available threads, but " + reqThreads + " were requested");
            }
        } else if (reqThreads != 1) {
            logger.warn("Ignoring request for " + reqThreads + " threads; not using OpenMP implementation");
        }
    }

    @Override
    public void computeLikelihoods(ReadDataHolder[] readDataArray, HaplotypeDataHolder[] haplotypeDataArray, double[] likelihoodArray) {
        this.computeLikelihoodsNative(readDataArray, haplotypeDataArray, likelihoodArray);
    }

    @Override
    public void done() {
        this.doneNative();
    }

    private static native void initNative(Class<?> var0, Class<?> var1, boolean var2, int var3, boolean var4);

    private native void computeLikelihoodsNative(Object[] var1, Object[] var2, double[] var3);

    private native void doneNative();
}

