/*
 * Decompiled with CFR 0.152.
 */
package htsjdk.samtools;

import htsjdk.samtools.SAMFlag;
import htsjdk.samtools.SAMFormatException;
import java.util.Locale;

public enum SamFlagField {
    NONE{

        @Override
        public String format(int flag) {
            throw new SAMFormatException("NONE not allowed for the SamFlagField when writing the SAM flag field.");
        }

        @Override
        protected int parseWithoutValidation(String flag) {
            throw new SAMFormatException("NONE not allowed for the SamFlagField when reading the SAM flag field.");
        }
    }
    ,
    DECIMAL{

        @Override
        public String format(int flag) {
            return Integer.toString(flag);
        }

        @Override
        protected int parseWithoutValidation(String flag) {
            return Integer.parseInt(flag);
        }
    }
    ,
    HEXADECIMAL{

        @Override
        public String format(int flag) {
            return String.format(Locale.US, "%#x", flag);
        }

        @Override
        protected int parseWithoutValidation(String flag) {
            return Integer.parseInt(flag.substring(2), 16);
        }
    }
    ,
    OCTAL{

        @Override
        public String format(int flag) {
            return String.format(Locale.US, "%#o", flag);
        }

        @Override
        protected int parseWithoutValidation(String flag) {
            return Integer.parseInt(flag, 8);
        }
    }
    ,
    STRING{

        @Override
        public String format(int flag) {
            StringBuilder value = new StringBuilder();
            if ((flag & SAMFlag.READ_UNMAPPED.flag) != 0) {
                value.append('u');
            } else {
                value.append('m');
            }
            if ((flag & SAMFlag.READ_REVERSE_STRAND.flag) != 0) {
                value.append('r');
            } else if ((flag & SAMFlag.READ_UNMAPPED.flag) == 0) {
                value.append('f');
            }
            if ((flag & SAMFlag.MATE_UNMAPPED.flag) != 0) {
                value.append('U');
            } else if ((flag & SAMFlag.READ_PAIRED.flag) != 0) {
                value.append('M');
            }
            if ((flag & SAMFlag.MATE_REVERSE_STRAND.flag) != 0) {
                value.append('R');
            } else if ((flag & SAMFlag.READ_PAIRED.flag) != 0) {
                value.append('F');
            }
            if ((flag & SAMFlag.READ_PAIRED.flag) != 0) {
                value.append('p');
            }
            if ((flag & SAMFlag.PROPER_PAIR.flag) != 0) {
                value.append('P');
            }
            if ((flag & SAMFlag.FIRST_OF_PAIR.flag) != 0) {
                value.append('1');
            }
            if ((flag & SAMFlag.SECOND_OF_PAIR.flag) != 0) {
                value.append('2');
            }
            if ((flag & SAMFlag.SECONDARY_ALIGNMENT.flag) != 0) {
                value.append('s');
            }
            if ((flag & SAMFlag.SUPPLEMENTARY_ALIGNMENT.flag) != 0) {
                value.append('S');
            }
            if ((flag & SAMFlag.READ_FAILS_VENDOR_QUALITY_CHECK.flag) != 0) {
                value.append('x');
            }
            if ((flag & SAMFlag.DUPLICATE_READ.flag) != 0) {
                value.append('d');
            }
            return value.toString();
        }

        @Override
        protected int parseWithoutValidation(String flag) {
            SamFlagField.validate(flag, 5.STRING);
            int value = 0;
            block15: for (int i = 0; i < flag.length(); ++i) {
                switch (flag.charAt(i)) {
                    case 'p': {
                        value |= SAMFlag.READ_PAIRED.flag;
                        continue block15;
                    }
                    case 'P': {
                        value |= SAMFlag.PROPER_PAIR.flag;
                        continue block15;
                    }
                    case 'u': {
                        value |= SAMFlag.READ_UNMAPPED.flag;
                        continue block15;
                    }
                    case 'U': {
                        value |= SAMFlag.MATE_UNMAPPED.flag;
                        continue block15;
                    }
                    case 'r': {
                        value |= SAMFlag.READ_REVERSE_STRAND.flag;
                        continue block15;
                    }
                    case 'R': {
                        value |= SAMFlag.MATE_REVERSE_STRAND.flag;
                        continue block15;
                    }
                    case '1': {
                        value |= SAMFlag.FIRST_OF_PAIR.flag;
                        continue block15;
                    }
                    case '2': {
                        value |= SAMFlag.SECOND_OF_PAIR.flag;
                        continue block15;
                    }
                    case 's': {
                        value |= SAMFlag.SECONDARY_ALIGNMENT.flag;
                        continue block15;
                    }
                    case 'x': {
                        value |= SAMFlag.READ_FAILS_VENDOR_QUALITY_CHECK.flag;
                        continue block15;
                    }
                    case 'd': {
                        value |= SAMFlag.DUPLICATE_READ.flag;
                        continue block15;
                    }
                    case 'S': {
                        value |= SAMFlag.SUPPLEMENTARY_ALIGNMENT.flag;
                        continue block15;
                    }
                    case 'F': 
                    case 'M': 
                    case '_': 
                    case 'f': 
                    case 'm': {
                        continue block15;
                    }
                    default: {
                        throw new SAMFormatException("Unknown flag character '" + flag.charAt(i) + "' in flag '" + flag + "'");
                    }
                }
            }
            return value;
        }
    };


    public abstract String format(int var1);

    public final int parse(String flag) {
        return this.parse(flag, true);
    }

    public static int parseDefault(String flag) {
        return SamFlagField.of(flag).parse(flag, false);
    }

    protected abstract int parseWithoutValidation(String var1);

    private int parse(String flag, boolean withValidation) {
        if (withValidation) {
            SamFlagField.validate(flag, this);
        }
        return this.parseWithoutValidation(flag);
    }

    public static SamFlagField of(String s) {
        if (s.isEmpty()) {
            throw new SAMFormatException("Could not determine flag field type; saw an empty flag field");
        }
        if (s.startsWith("0x")) {
            return HEXADECIMAL;
        }
        if (s.startsWith("0X")) {
            return HEXADECIMAL;
        }
        if (s.startsWith("0") && s.length() > 1) {
            return OCTAL;
        }
        if (Character.isDigit(s.charAt(0))) {
            return DECIMAL;
        }
        return STRING;
    }

    private static void validate(String flag, SamFlagField expectedField) {
        SamFlagField actualField = SamFlagField.of(flag);
        if (actualField != expectedField) {
            throw new SAMFormatException(expectedField.name() + " sam flag must start with [1-9] but found '" + flag + "' (" + actualField.name() + ")");
        }
    }
}

