/*
 * Decompiled with CFR 0.152.
 */
package org.broadinstitute.barclay.argparser;

import java.io.PrintStream;
import java.lang.reflect.Constructor;
import java.lang.reflect.Field;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.ParameterizedType;
import java.lang.reflect.Type;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import org.broadinstitute.barclay.argparser.CommandLineArgumentParser;
import org.broadinstitute.barclay.argparser.CommandLineException;
import org.broadinstitute.barclay.argparser.CommandLineParser;
import org.broadinstitute.barclay.utils.Utils;

public abstract class ArgumentDefinition {
    protected static final String OPTION_DOC_PREFIX = "Possible values: {";
    protected static final String OPTION_DOC_SUFFIX = "} ";
    private final Field underlyingField;
    private final Object containingObject;
    private final Class<?> underlyingFieldClass;
    private final boolean isCollection;
    private List<String> originalCommandLineValues;

    public ArgumentDefinition(Object containingObject, Field underlyingField) {
        Utils.nonNull(underlyingField, "An underlying field must be provided");
        Utils.nonNull(containingObject, "A containing object must be provided");
        this.underlyingField = underlyingField;
        this.containingObject = containingObject;
        this.underlyingField.setAccessible(true);
        this.underlyingFieldClass = this.getClassForUnderlyingField();
        this.isCollection = ArgumentDefinition.isCollectionField(underlyingField);
        if (!this.canBeMadeFromString()) {
            throw new CommandLineException.CommandLineParserInternalException(String.format("Field for argument '%s' must have a String constructor or be an enum", this.getUnderlyingField().getName()));
        }
    }

    public Field getUnderlyingField() {
        return this.underlyingField;
    }

    public Object getContainingObject() {
        return this.containingObject;
    }

    public Class<?> getUnderlyingFieldClass() {
        return this.underlyingFieldClass;
    }

    public boolean isCollection() {
        return this.isCollection;
    }

    public Object getArgumentValue() {
        try {
            return this.getUnderlyingField().get(this.getContainingObject());
        }
        catch (IllegalAccessException e) {
            throw new CommandLineException.ShouldNeverReachHereException("This shouldn't happen since we setAccessible(true).", e);
        }
    }

    public abstract void setArgumentValues(CommandLineArgumentParser var1, PrintStream var2, List<String> var3);

    public abstract void validateValues(CommandLineArgumentParser var1);

    public abstract String getCommandLineDisplayString();

    public void setOriginalCommandLineValues(List<String> commandLineDisplayValue) {
        this.originalCommandLineValues = commandLineDisplayValue;
    }

    public List<String> getOriginalCommandLineValues() {
        return this.originalCommandLineValues;
    }

    protected Class<?> getClassForUnderlyingField() {
        Field field = this.getUnderlyingField();
        if (ArgumentDefinition.isCollectionField(field)) {
            ParameterizedType clazz = (ParameterizedType)field.getGenericType();
            Type[] genericTypes = clazz.getActualTypeArguments();
            if (genericTypes.length != 1) {
                throw new CommandLineException.CommandLineParserInternalException(String.format("Strange collection type for field %s", field.getName()));
            }
            return (Class)(genericTypes[0] instanceof ParameterizedType ? ((ParameterizedType)genericTypes[0]).getRawType() : genericTypes[0]);
        }
        Class<?> type = field.getType();
        if (type == Byte.TYPE) {
            return Byte.class;
        }
        if (type == Short.TYPE) {
            return Short.class;
        }
        if (type == Integer.TYPE) {
            return Integer.class;
        }
        if (type == Long.TYPE) {
            return Long.class;
        }
        if (type == Float.TYPE) {
            return Float.class;
        }
        if (type == Double.TYPE) {
            return Double.class;
        }
        if (type == Boolean.TYPE) {
            return Boolean.class;
        }
        return type;
    }

    protected void intializeCollection(String annotationType) {
        Field field = this.getUnderlyingField();
        Object callerArguments = this.containingObject;
        try {
            if (field.get(this.containingObject) == null) {
                field.set(callerArguments, field.getType().newInstance());
            }
        }
        catch (Exception ex) {
            try {
                field.set(callerArguments, new ArrayList());
            }
            catch (IllegalArgumentException e) {
                throw new CommandLineException.CommandLineParserInternalException(String.format("Collection member %s of type %s must be explicitly initialized. It cannot be constructed or auto-initialized with ArrayList.", field.getName(), annotationType));
            }
            catch (IllegalAccessException e) {
                throw new CommandLineException.ShouldNeverReachHereException("We should not have reached here because we set accessible to true", e);
            }
        }
    }

    protected static boolean isCollectionField(Field field) {
        try {
            field.getType().asSubclass(Collection.class);
            return true;
        }
        catch (ClassCastException e) {
            return false;
        }
    }

    protected Object constructFromString(String stringValue, String argumentName) {
        Class<?> clazz = this.getUnderlyingFieldClass();
        try {
            if (clazz.isEnum()) {
                try {
                    return Enum.valueOf(clazz, stringValue);
                }
                catch (IllegalArgumentException e) {
                    throw new CommandLineException.BadArgumentValue(argumentName, stringValue, String.format("'%s' is not a valid value for %s. Allowed values are %s", stringValue, clazz.getSimpleName(), ArgumentDefinition.getEnumOptions(clazz)));
                }
            }
            Constructor<?> ctor = clazz.getDeclaredConstructor(String.class);
            ctor.setAccessible(true);
            return ctor.newInstance(stringValue);
        }
        catch (NoSuchMethodException e) {
            throw new CommandLineException.ShouldNeverReachHereException(String.format("Cannot find string ctor for %s", clazz.getName()), e);
        }
        catch (InstantiationException e) {
            throw new CommandLineException.CommandLineParserInternalException(String.format("Abstract class '%s' cannot be used for an argument value type.", clazz.getSimpleName()), e);
        }
        catch (IllegalAccessException e) {
            throw new CommandLineException.CommandLineParserInternalException(String.format("String constructor for argument value type '%s' must be public.", clazz.getSimpleName()), e);
        }
        catch (InvocationTargetException e) {
            throw new CommandLineException.BadArgumentValue(argumentName, stringValue, String.format("Failure constructing '%s' from the string '%s'.", clazz.getSimpleName(), stringValue));
        }
    }

    protected String getOptionsAsDisplayString() {
        Class<?> clazz = this.getUnderlyingFieldClass();
        if (clazz == Boolean.class) {
            return String.format("%s%s, %s%s", OPTION_DOC_PREFIX, Boolean.TRUE, Boolean.FALSE, OPTION_DOC_SUFFIX);
        }
        if (clazz.isEnum()) {
            Class<?> enumClass = clazz;
            return ArgumentDefinition.getEnumOptions(enumClass);
        }
        return "";
    }

    private boolean canBeMadeFromString() {
        Class<?> clazz = this.getClassForUnderlyingField();
        if (clazz.isEnum()) {
            return true;
        }
        try {
            clazz.getDeclaredConstructor(String.class);
            return true;
        }
        catch (NoSuchMethodException e) {
            return false;
        }
    }

    private static <T extends Enum<T>> String getEnumOptions(Class<T> clazz) {
        Enum[] enumConstants = (Enum[])clazz.getEnumConstants();
        if (enumConstants.length == 0) {
            throw new CommandLineException(String.format("Bad argument enum type '%s' with no options", clazz.getName()));
        }
        if (CommandLineParser.ClpEnum.class.isAssignableFrom(clazz)) {
            return Stream.of(enumConstants).map(c -> String.format("%s (%s)", c.name(), ((CommandLineParser.ClpEnum)((Object)c)).getHelpDoc())).collect(Collectors.joining("\n"));
        }
        return Stream.of(enumConstants).map(Enum::name).collect(Collectors.joining(", ", OPTION_DOC_PREFIX, OPTION_DOC_SUFFIX));
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        ArgumentDefinition that = (ArgumentDefinition)o;
        if (!this.getUnderlyingField().equals(that.getUnderlyingField())) {
            return false;
        }
        return this.getContainingObject().equals(that.getContainingObject());
    }

    public int hashCode() {
        int result = this.getUnderlyingField().hashCode();
        result = 31 * result + this.getContainingObject().hashCode();
        return result;
    }
}

