/*
 * Decompiled with CFR 0.152.
 */
package org.broadinstitute.barclay.argparser;

import java.io.BufferedReader;
import java.io.FileReader;
import java.io.IOException;
import java.io.PrintStream;
import java.lang.reflect.Field;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.LinkedHashMap;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.stream.Collectors;
import joptsimple.OptionException;
import joptsimple.OptionParser;
import joptsimple.OptionSet;
import joptsimple.OptionSpec;
import joptsimple.OptionSpecBuilder;
import org.apache.commons.lang3.StringUtils;
import org.apache.commons.lang3.tuple.Pair;
import org.broadinstitute.barclay.argparser.Argument;
import org.broadinstitute.barclay.argparser.ArgumentCollection;
import org.broadinstitute.barclay.argparser.ArgumentDefinition;
import org.broadinstitute.barclay.argparser.BetaFeature;
import org.broadinstitute.barclay.argparser.ClassFinder;
import org.broadinstitute.barclay.argparser.CommandLineException;
import org.broadinstitute.barclay.argparser.CommandLineParser;
import org.broadinstitute.barclay.argparser.CommandLineParserOptions;
import org.broadinstitute.barclay.argparser.CommandLineParserUtilities;
import org.broadinstitute.barclay.argparser.CommandLinePluginDescriptor;
import org.broadinstitute.barclay.argparser.CommandLineProgramProperties;
import org.broadinstitute.barclay.argparser.ExperimentalFeature;
import org.broadinstitute.barclay.argparser.NamedArgumentDefinition;
import org.broadinstitute.barclay.argparser.PositionalArgumentDefinition;
import org.broadinstitute.barclay.argparser.PositionalArguments;
import org.broadinstitute.barclay.argparser.StrictBooleanConverter;
import org.broadinstitute.barclay.argparser.TaggedArgumentParser;
import org.broadinstitute.barclay.utils.Utils;

public final class CommandLineArgumentParser
implements CommandLineParser {
    private static final int ARGUMENT_COLUMN_WIDTH = 30;
    private static final int DESCRIPTION_COLUMN_WIDTH = 90;
    private static final String defaultUsagePreamble = "Usage: program [arguments...]\n";
    private static final String defaultUsagePreambleWithPositionalArguments = "Usage: program [arguments...] [positional-arguments...]\n";
    protected static final String BETA_PREFIX = "\n\n**BETA FEATURE - WORK IN PROGRESS**\n\n";
    protected static final String EXPERIMENTAL_PREFIX = "\n\n**EXPERIMENTAL FEATURE - USE AT YOUR OWN RISK**\n\n";
    protected static final String ARGUMENT_FILE_COMMENT = "#";
    protected static final String EXPANSION_FILE_EXTENSION_LIST = ".list";
    protected static final String EXPANSION_FILE_EXTENSIONS_ARGS = ".args";
    protected static final Set<String> EXPANSION_FILE_EXTENSIONS = new HashSet<String>(Arrays.asList(".list", ".args"));
    private final Object callerArguments;
    private final Set<CommandLineParserOptions> parserOptions;
    private PositionalArgumentDefinition positionalArgumentDefinition;
    private List<NamedArgumentDefinition> namedArgumentDefinitions = new ArrayList<NamedArgumentDefinition>();
    private final Map<String, NamedArgumentDefinition> namedArgumentsDefinitionsByAlias = new LinkedHashMap<String, NamedArgumentDefinition>();
    private final CommandLineProgramProperties programProperties;
    private final Map<String, CommandLinePluginDescriptor<?>> pluginDescriptors = new HashMap();
    private final TaggedArgumentParser tagParser = new TaggedArgumentParser();
    private final Set<String> argumentsFilesLoadedAlready = new LinkedHashSet<String>();

    public CommandLineArgumentParser(Object callerArguments) {
        this(callerArguments, Collections.emptyList(), Collections.emptySet());
    }

    public CommandLineArgumentParser(Object callerArguments, List<? extends CommandLinePluginDescriptor<?>> pluginDescriptors, Set<CommandLineParserOptions> parserOptions) {
        Utils.nonNull(callerArguments, "The object with command line arguments cannot be null");
        Utils.nonNull(pluginDescriptors, "The list of pluginDescriptors cannot be null");
        Utils.nonNull(parserOptions, "The set of parser options cannot be null");
        this.callerArguments = callerArguments;
        this.parserOptions = parserOptions;
        Class<?> callerArgumentsClass = this.callerArguments.getClass();
        if (callerArgumentsClass.getAnnotation(ExperimentalFeature.class) != null && callerArgumentsClass.getAnnotation(BetaFeature.class) != null) {
            throw new CommandLineException.CommandLineParserInternalException("Features cannot be both Beta and Experimental");
        }
        this.programProperties = callerArgumentsClass.getAnnotation(CommandLineProgramProperties.class);
        this.createArgumentDefinitions(callerArguments, null);
        this.createCommandLinePluginArgumentDefinitions(pluginDescriptors);
        this.validateArgumentDefinitions();
    }

    @Override
    public boolean parseArguments(PrintStream messageStream, String[] args) {
        List<String> newArgs;
        OptionSet parsedArguments;
        OptionParser parser = this.getOptionParser();
        try {
            parsedArguments = parser.parse(this.tagParser.preprocessTaggedOptions(args));
        }
        catch (OptionException e) {
            throw new CommandLineException(e.getMessage());
        }
        if (this.isSpecialFlagSet(parsedArguments, "help")) {
            messageStream.print(this.usage(true, this.isSpecialFlagSet(parsedArguments, "showHidden")));
            return false;
        }
        if (this.isSpecialFlagSet(parsedArguments, "version")) {
            messageStream.println(this.getVersion());
            return false;
        }
        if (parsedArguments.has("arguments_file") && !(newArgs = this.expandFromArgumentFile(parsedArguments)).isEmpty()) {
            this.tagParser.resetTagSurrogates();
            newArgs.addAll(Arrays.asList(args));
            return this.parseArguments(messageStream, newArgs.toArray(new String[newArgs.size()]));
        }
        return this.propagateParsedValues(parsedArguments, messageStream);
    }

    public List<NamedArgumentDefinition> getNamedArgumentDefinitions() {
        return this.namedArgumentDefinitions;
    }

    public NamedArgumentDefinition getNamedArgumentDefinitionByAlias(String argumentAlias) {
        return this.namedArgumentsDefinitionsByAlias.get(argumentAlias);
    }

    public PositionalArgumentDefinition getPositionalArgumentDefinition() {
        return this.positionalArgumentDefinition;
    }

    public TaggedArgumentParser getTaggedArgumentParser() {
        return this.tagParser;
    }

    @Override
    public String getVersion() {
        return "Version:" + this.callerArguments.getClass().getPackage().getImplementationVersion();
    }

    @Override
    public <T> T getPluginDescriptor(Class<T> targetDescriptor) {
        return targetDescriptor.cast(this.pluginDescriptors.get(targetDescriptor.getName()));
    }

    public boolean getAppendToCollectionsParserOption() {
        return this.parserOptions.contains((Object)CommandLineParserOptions.APPEND_TO_COLLECTIONS);
    }

    @Override
    public String getCommandLine() {
        String tempString;
        StringBuilder commandLineString = new StringBuilder();
        commandLineString.append(this.callerArguments.getClass().getSimpleName());
        if (this.positionalArgumentDefinition != null) {
            tempString = this.positionalArgumentDefinition.getCommandLineDisplayString();
            commandLineString.append(tempString.length() > 0 ? " " + tempString : "");
        }
        commandLineString.append((tempString = this.namedArgumentDefinitions.stream().filter(NamedArgumentDefinition::getHasBeenSet).map(NamedArgumentDefinition::getCommandLineDisplayString).collect(Collectors.joining(" "))).length() > 0 ? " " + tempString : "");
        tempString = this.namedArgumentDefinitions.stream().filter(argumentDefinition -> !argumentDefinition.getHasBeenSet() && !argumentDefinition.getDefaultValueAsString().equals("null")).map(NamedArgumentDefinition::getCommandLineDisplayString).collect(Collectors.joining(" "));
        commandLineString.append(tempString.length() > 0 ? " " + tempString : "");
        return commandLineString.toString();
    }

    @Override
    public String getStandardUsagePreamble(Class<?> mainClass) {
        String preamble = "USAGE: " + mainClass.getSimpleName() + " [arguments]\n\n";
        if (mainClass.getAnnotation(ExperimentalFeature.class) != null) {
            return EXPERIMENTAL_PREFIX + preamble;
        }
        if (mainClass.getAnnotation(BetaFeature.class) != null) {
            return BETA_PREFIX + preamble;
        }
        return preamble;
    }

    private void validateArgumentDefinitions() {
        for (NamedArgumentDefinition mutexSourceDef : this.namedArgumentDefinitions) {
            for (String mutexTarget : mutexSourceDef.getMutexTargetList()) {
                NamedArgumentDefinition mutexTargetDef = this.namedArgumentsDefinitionsByAlias.get(mutexTarget);
                if (mutexTargetDef == null) {
                    throw new CommandLineException.CommandLineParserInternalException(String.format("Argument '%s' references a nonexistent mutex argument '%s'", mutexSourceDef.getArgumentAliasDisplayString(), mutexTarget));
                }
                mutexTargetDef.addMutexTarget(mutexSourceDef.getLongName());
            }
        }
    }

    private String getUsagePreamble() {
        StringBuilder usagePreamble = new StringBuilder();
        if (null != this.programProperties) {
            usagePreamble.append(this.programProperties.summary());
        } else if (this.positionalArgumentDefinition == null) {
            usagePreamble.append(defaultUsagePreamble);
        } else {
            usagePreamble.append(defaultUsagePreambleWithPositionalArguments);
        }
        return usagePreamble.toString();
    }

    private void addAllAliases(NamedArgumentDefinition arg) {
        for (String key : arg.getArgumentAliases()) {
            this.namedArgumentsDefinitionsByAlias.put(key, arg);
        }
    }

    private boolean inArgumentMap(NamedArgumentDefinition arg) {
        for (String key : arg.getArgumentAliases()) {
            if (!this.namedArgumentsDefinitionsByAlias.containsKey(key)) continue;
            return true;
        }
        return false;
    }

    private void createArgumentDefinitions(Object callerArguments, CommandLinePluginDescriptor<?> controllingDescriptor) {
        for (Field field : CommandLineParserUtilities.getAllFields(callerArguments.getClass())) {
            PositionalArguments positionalArgumentAnnotation = field.getAnnotation(PositionalArguments.class);
            Argument argumentAnnotation = field.getAnnotation(Argument.class);
            ArgumentCollection argumentCollectionAnnotation = field.getAnnotation(ArgumentCollection.class);
            String errorString = String.format("Field %s: Only one of @Argument, @ArgumentCollection or @PositionalArguments can be used", field.getName());
            if (positionalArgumentAnnotation != null) {
                if (argumentAnnotation != null || argumentCollectionAnnotation != null) {
                    throw new CommandLineException.CommandLineParserInternalException(errorString);
                }
                this.positionalArgumentDefinition = this.handlePositionalArgumentAnnotation(positionalArgumentAnnotation, callerArguments, field);
                continue;
            }
            if (argumentAnnotation != null) {
                if (argumentCollectionAnnotation != null) {
                    throw new CommandLineException.CommandLineParserInternalException(errorString);
                }
                this.handleArgumentAnnotation(argumentAnnotation, callerArguments, field, controllingDescriptor);
                continue;
            }
            if (argumentCollectionAnnotation == null) continue;
            try {
                field.setAccessible(true);
                Object fieldInstance = field.get(callerArguments);
                if (fieldInstance == null) {
                    throw new CommandLineException.CommandLineParserInternalException(String.format("The ArgumentCollection field '%s' in '%s' must have an initial value", field.getName(), callerArguments.getClass().getName()));
                }
                this.createArgumentDefinitions(fieldInstance, controllingDescriptor);
            }
            catch (IllegalAccessException e) {
                throw new CommandLineException.ShouldNeverReachHereException("should never reach here because we setAccessible(true)", e);
            }
        }
    }

    private void createCommandLinePluginArgumentDefinitions(List<? extends CommandLinePluginDescriptor<?>> requestedPluginDescriptors) {
        requestedPluginDescriptors.forEach(descriptor -> {
            this.pluginDescriptors.put(descriptor.getClass().getName(), (CommandLinePluginDescriptor<?>)descriptor);
            this.createArgumentDefinitions(descriptor, null);
            this.findPluginsForDescriptor((CommandLinePluginDescriptor<?>)descriptor);
        });
    }

    private void findPluginsForDescriptor(CommandLinePluginDescriptor<?> pluginDescriptor) {
        ClassFinder classFinder = new ClassFinder();
        pluginDescriptor.getPackageNames().forEach(pkg -> classFinder.find((String)pkg, pluginDescriptor.getPluginBaseClass()));
        Set<Class<?>> pluginClasses = classFinder.getClasses();
        for (Class<?> c : pluginClasses) {
            if (!pluginDescriptor.includePluginClass(c)) continue;
            try {
                Object plugin = pluginDescriptor.createInstanceForPlugin(c);
                this.createArgumentDefinitions(plugin, pluginDescriptor);
            }
            catch (IllegalAccessException | InstantiationException e) {
                throw new CommandLineException.CommandLineParserInternalException("Problem making an instance of plugin " + c + " Do check that the class has a non-arg constructor", e);
            }
        }
    }

    private final void printArgumentUsageBlock(StringBuilder sb, String preamble, List<NamedArgumentDefinition> args) {
        if (args != null && !args.isEmpty()) {
            sb.append(preamble);
            args.stream().sorted(NamedArgumentDefinition.sortByLongName).forEach(argumentDefinition -> sb.append(argumentDefinition.getArgumentUsage(this.namedArgumentsDefinitionsByAlias, this.pluginDescriptors.values(), 30, 90)));
        }
    }

    @Override
    public String usage(boolean printCommon, boolean printHidden) {
        List<NamedArgumentDefinition> conditionalArgs;
        StringBuilder sb = new StringBuilder();
        String preamble = this.getStandardUsagePreamble(this.callerArguments.getClass()) + this.getUsagePreamble();
        sb.append(Utils.wrapParagraph(preamble, 120));
        sb.append("\n" + this.getVersion() + "\n");
        Map<Boolean, List<NamedArgumentDefinition>> allArgsMap = this.namedArgumentDefinitions.stream().filter(argumentDefinition -> printCommon || !argumentDefinition.isCommon()).filter(argumentDefinition -> printHidden || !argumentDefinition.isHidden()).collect(Collectors.partitioningBy(a -> a.getDescriptorForControllingPlugin() == null));
        List<NamedArgumentDefinition> nonPluginArgs = allArgsMap.get(true);
        if (null != nonPluginArgs && !nonPluginArgs.isEmpty()) {
            Map<Boolean, List<NamedArgumentDefinition>> unconditionalArgsMap = nonPluginArgs.stream().collect(Collectors.partitioningBy(a -> a.isOptional()));
            this.printArgumentUsageBlock(sb, "\n\nRequired Arguments:\n\n", unconditionalArgsMap.get(false));
            List<NamedArgumentDefinition> optArgs = unconditionalArgsMap.get(true);
            if (null != optArgs && !optArgs.isEmpty()) {
                Map<Boolean, List<NamedArgumentDefinition>> byAdvanced = optArgs.stream().collect(Collectors.partitioningBy(a -> a.isAdvanced()));
                this.printArgumentUsageBlock(sb, "\nOptional Arguments:\n\n", byAdvanced.get(false));
                this.printArgumentUsageBlock(sb, "\nAdvanced Arguments:\n\n", byAdvanced.get(true));
            }
        }
        if (null != (conditionalArgs = allArgsMap.get(false)) && !conditionalArgs.isEmpty()) {
            Map<CommandLinePluginDescriptor, List<NamedArgumentDefinition>> argsByControllingDescriptor = conditionalArgs.stream().collect(Collectors.groupingBy(argDef -> argDef.getDescriptorForControllingPlugin()));
            ArrayList<CommandLinePluginDescriptor> pluginDescriptorSortedByName = new ArrayList<CommandLinePluginDescriptor>(argsByControllingDescriptor.keySet());
            pluginDescriptorSortedByName.sort((a, b) -> String.CASE_INSENSITIVE_ORDER.compare(a.getDisplayName(), b.getDisplayName()));
            for (CommandLinePluginDescriptor descriptor : pluginDescriptorSortedByName) {
                sb.append("Conditional Arguments for " + descriptor.getDisplayName() + ":\n\n");
                Map<String, List<NamedArgumentDefinition>> byPlugin = argsByControllingDescriptor.get(descriptor).stream().collect(Collectors.groupingBy(argDef -> argDef.getContainingObject().getClass().getSimpleName()));
                ArrayList<String> sortedPluginNames = new ArrayList<String>(byPlugin.keySet());
                sortedPluginNames.sort(String.CASE_INSENSITIVE_ORDER);
                for (String pluginName : sortedPluginNames) {
                    this.printArgumentUsageBlock(sb, "Valid only if \"" + pluginName + "\" is specified:\n", byPlugin.get(pluginName));
                }
            }
        }
        return sb.toString();
    }

    private boolean propagateParsedValues(OptionSet parsedArguments, PrintStream messageStream) {
        for (OptionSpec<?> optSpec : parsedArguments.asMap().keySet()) {
            if (!parsedArguments.has(optSpec)) continue;
            NamedArgumentDefinition namedArgumentDefinition = this.namedArgumentsDefinitionsByAlias.get(optSpec.options().get(0));
            namedArgumentDefinition.setArgumentValues(this, messageStream, optSpec.values(parsedArguments).stream().map(Object::toString).collect(Collectors.toList()));
        }
        if (!parsedArguments.nonOptionArguments().isEmpty()) {
            List<String> stringValues = parsedArguments.nonOptionArguments().stream().map(v -> v.toString()).collect(Collectors.toList());
            if (this.positionalArgumentDefinition == null) {
                throw new CommandLineException.BadArgumentValue(String.format("Positional arguments were provided '%s' but no positional argument is defined for this tool.", stringValues.stream().collect(Collectors.joining("{", ",", "}"))));
            }
            this.positionalArgumentDefinition.setArgumentValues(this, messageStream, stringValues);
        }
        this.validateArgumentValues();
        return true;
    }

    private List<String> expandFromArgumentFile(OptionSet parsedArguments) {
        List argfiles = parsedArguments.valuesOf("arguments_file").stream().map(f -> (String)f).collect(Collectors.toList());
        List<String> newArgs = argfiles.stream().distinct().filter(file -> !this.argumentsFilesLoadedAlready.contains(file)).flatMap(file -> this.loadArgumentsFile((String)file).stream()).collect(Collectors.toList());
        this.argumentsFilesLoadedAlready.addAll(argfiles);
        return newArgs;
    }

    private OptionParser getOptionParser() {
        OptionParser parser = new OptionParser(false);
        for (NamedArgumentDefinition argDef : this.namedArgumentDefinitions) {
            OptionSpecBuilder bld = parser.acceptsAll(argDef.getArgumentAliases(), argDef.getDocString());
            if (argDef.isFlag()) {
                bld.withOptionalArg().withValuesConvertedBy(new StrictBooleanConverter());
                continue;
            }
            bld.withRequiredArg();
        }
        if (this.positionalArgumentDefinition != null) {
            parser.nonOptions();
        }
        return parser;
    }

    private boolean isSpecialFlagSet(OptionSet parsedArguments, String flagName) {
        if (parsedArguments.has(flagName)) {
            Object value = parsedArguments.valueOf(flagName);
            return value == null || !value.equals("false");
        }
        return false;
    }

    private void validateArgumentValues() {
        this.namedArgumentDefinitions = this.validatePluginArgumentValues();
        for (NamedArgumentDefinition argumentDefinition : this.namedArgumentDefinitions) {
            argumentDefinition.validateValues(this);
        }
        if (this.positionalArgumentDefinition != null) {
            this.positionalArgumentDefinition.validateValues(this);
        }
    }

    private List<NamedArgumentDefinition> validatePluginArgumentValues() {
        ArrayList<NamedArgumentDefinition> actualArgumentDefinitions = new ArrayList<NamedArgumentDefinition>();
        for (NamedArgumentDefinition argumentDefinition : this.namedArgumentDefinitions) {
            if (!argumentDefinition.isControlledByPlugin()) {
                actualArgumentDefinitions.add(argumentDefinition);
                continue;
            }
            boolean isAllowed = argumentDefinition.getDescriptorForControllingPlugin().isDependentArgumentAllowed(argumentDefinition.getContainingObject().getClass());
            if (argumentDefinition.getHasBeenSet()) {
                if (!isAllowed) {
                    throw new CommandLineException(String.format("Argument \"%s/%s\" is only valid when the argument \"%s\" is specified", argumentDefinition.getShortName(), argumentDefinition.getLongName(), argumentDefinition.getContainingObject().getClass().getSimpleName()));
                }
                actualArgumentDefinitions.add(argumentDefinition);
                continue;
            }
            if (!isAllowed) continue;
            actualArgumentDefinitions.add(argumentDefinition);
        }
        this.pluginDescriptors.entrySet().forEach(e -> ((CommandLinePluginDescriptor)e.getValue()).validateAndResolvePlugins());
        return actualArgumentDefinitions;
    }

    public List<String> expandFromExpansionFile(ArgumentDefinition argumentDefinition, PrintStream messageStream, String stringValue, List<String> originalValuesForPreservation) {
        ArrayList<String> expandedValues = new ArrayList<String>();
        if (EXPANSION_FILE_EXTENSIONS.stream().anyMatch(ext -> stringValue.endsWith((String)ext))) {
            expandedValues.addAll(CommandLineArgumentParser.loadCollectionListFile(stringValue, messageStream));
            argumentDefinition.setOriginalCommandLineValues(originalValuesForPreservation);
        } else {
            expandedValues.add(stringValue);
        }
        return expandedValues;
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private static List<String> loadCollectionListFile(String collectionListFile, PrintStream messageStream) {
        try (BufferedReader reader = new BufferedReader(new FileReader(collectionListFile));){
            List<String> filteredStrings = reader.lines().map(String::trim).filter(line -> !line.isEmpty()).filter(line -> !line.startsWith(ARGUMENT_FILE_COMMENT)).collect(Collectors.toList());
            List suspiciousString = filteredStrings.stream().filter(s -> s.startsWith("@")).limit(1L).collect(Collectors.toList());
            if (!suspiciousString.isEmpty()) {
                messageStream.println(String.format("WARNING: the file %s has a file extension that causes it to be expanded by the argument parser into multiple argument values , but contains lines with leading '@' characters that may indicate this was unintentional (%s).", collectionListFile, suspiciousString));
            }
            List<String> list = filteredStrings;
            return list;
        }
        catch (IOException e) {
            throw new CommandLineException("I/O error loading list file:" + collectionListFile, e);
        }
    }

    private List<String> loadArgumentsFile(String argumentsFile) {
        ArrayList<String> args = new ArrayList<String>();
        try (BufferedReader reader = new BufferedReader(new FileReader(argumentsFile));){
            String line;
            while ((line = reader.readLine()) != null) {
                if (line.startsWith(ARGUMENT_FILE_COMMENT) || line.trim().isEmpty()) continue;
                args.addAll(Arrays.asList(StringUtils.split(line)));
            }
        }
        catch (IOException e) {
            throw new CommandLineException("I/O error loading arguments file:" + argumentsFile, e);
        }
        return args;
    }

    private void handleArgumentAnnotation(Argument argumentAnnotation, Object parent, Field field, CommandLinePluginDescriptor<?> controllingDescriptor) {
        NamedArgumentDefinition argumentDefinition = new NamedArgumentDefinition(argumentAnnotation, parent, field, controllingDescriptor);
        if (this.inArgumentMap(argumentDefinition)) {
            throw new CommandLineException.CommandLineParserInternalException(argumentDefinition.getArgumentAliasDisplayString() + " has already been used.");
        }
        this.addAllAliases(argumentDefinition);
        this.namedArgumentDefinitions.add(argumentDefinition);
    }

    private PositionalArgumentDefinition handlePositionalArgumentAnnotation(PositionalArguments positionalArguments, Object parent, Field field) {
        if (this.positionalArgumentDefinition != null) {
            throw new CommandLineException.CommandLineParserInternalException("@PositionalArguments cannot be used more than once in an argument class.");
        }
        return new PositionalArgumentDefinition(positionalArguments, parent, field);
    }

    @Override
    public <T> List<Pair<ArgumentDefinition, T>> gatherArgumentValuesOfType(Class<T> type) {
        ArrayList<Pair<ArgumentDefinition, T>> argumentValues = new ArrayList<Pair<ArgumentDefinition, T>>();
        ArrayList<ArgumentDefinition> allArgDefs = new ArrayList<ArgumentDefinition>(this.namedArgumentDefinitions.size());
        allArgDefs.addAll(this.namedArgumentDefinitions);
        if (this.positionalArgumentDefinition != null) {
            allArgDefs.add(this.positionalArgumentDefinition);
        }
        for (ArgumentDefinition argDef : allArgDefs) {
            if (!type.isAssignableFrom(argDef.getUnderlyingFieldClass())) continue;
            if (argDef.isCollection()) {
                Collection argumentContainer = (Collection)argDef.getArgumentValue();
                if (argumentContainer.isEmpty()) {
                    argumentValues.add(Pair.of(argDef, null));
                    continue;
                }
                for (Object argumentValue : argumentContainer) {
                    argumentValues.add(Pair.of(argDef, type.cast(argumentValue)));
                }
                continue;
            }
            argumentValues.add(Pair.of(argDef, type.cast(argDef.getArgumentValue())));
        }
        return argumentValues;
    }
}

