/*
 * Decompiled with CFR 0.152.
 */
package org.broadinstitute.barclay.help;

import com.google.gson.Gson;
import com.google.gson.GsonBuilder;
import com.sun.javadoc.ClassDoc;
import com.sun.javadoc.ProgramElementDoc;
import com.sun.javadoc.RootDoc;
import freemarker.cache.ClassTemplateLoader;
import freemarker.cache.FileTemplateLoader;
import freemarker.cache.TemplateLoader;
import freemarker.template.Configuration;
import freemarker.template.DefaultObjectWrapper;
import freemarker.template.Template;
import freemarker.template.TemplateException;
import java.io.BufferedWriter;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.FileWriter;
import java.io.IOException;
import java.io.OutputStreamWriter;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.TreeSet;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.broadinstitute.barclay.argparser.Hidden;
import org.broadinstitute.barclay.help.DefaultDocWorkUnitHandler;
import org.broadinstitute.barclay.help.DocException;
import org.broadinstitute.barclay.help.DocWorkUnit;
import org.broadinstitute.barclay.help.DocletUtils;
import org.broadinstitute.barclay.help.DocumentedFeature;
import org.broadinstitute.barclay.help.GSONWorkUnit;
import org.broadinstitute.barclay.utils.JVMUtils;

public class HelpDoclet {
    protected static final Logger logger = LogManager.getLogger(HelpDoclet.class);
    private static final String DESTINATION_DIR_OPTION = "-d";
    private static final String WINDOW_TITLE_OPTION = "-windowtitle";
    private static final String DOC_TITLE_OPTION = "-doctitle";
    private static final String QUIET_OPTION = "-quiet";
    private static final String SETTINGS_DIR_OPTION = "-settings-dir";
    private static final String BUILD_TIMESTAMP_OPTION = "-build-timestamp";
    private static final String ABSOLUTE_VERSION_OPTION = "-absolute-version";
    private static final String INCLUDE_HIDDEN_OPTION = "-hidden-version";
    private static final String OUTPUT_FILE_EXTENSION_OPTION = "-output-file-extension";
    private static final String INDEX_FILE_EXTENSION_OPTION = "-index-file-extension";
    private static final String USE_DEFAULT_TEMPLATES_OPTION = "-use-default-templates";
    private static final File DEFAULT_SETTINGS_DIR = new File("settings/helpTemplates");
    private static final String DEFAULT_SETTINGS_CLASSPATH = "/org/broadinstitute/barclay/helpTemplates";
    private static final File DEFAULT_DESTINATION_DIR = new File("barclaydocs");
    private static final String DEFAULT_OUTPUT_FILE_EXTENSION = "html";
    protected static File settingsDir = DEFAULT_SETTINGS_DIR;
    protected boolean isSettingsDirSet = false;
    protected static File destinationDir = DEFAULT_DESTINATION_DIR;
    protected static String outputFileExtension = "html";
    protected static String indexFileExtension = "html";
    protected static String buildTimestamp = "[no timestamp available]";
    protected static String absoluteVersion = "[no version available]";
    protected static boolean showHiddenFeatures = false;
    protected boolean useDefaultTemplates = false;
    private RootDoc rootDoc;
    protected Set<DocWorkUnit> workUnits;

    public static boolean start(RootDoc rootDoc) throws IOException {
        return new HelpDoclet().startProcessDocs(rootDoc);
    }

    private void validateSettingsDir() {
        if (!settingsDir.exists()) {
            throw new RuntimeException("-settings-dir : " + settingsDir.getPath() + " does not exist!");
        }
        if (!settingsDir.isDirectory()) {
            throw new RuntimeException("-settings-dir : " + settingsDir.getPath() + " is not a directory!");
        }
    }

    protected void validateDocletStartingState() {
    }

    protected boolean startProcessDocs(RootDoc rootDoc) throws IOException {
        for (String[] options : rootDoc.options()) {
            this.parseOption(options);
        }
        if (this.useDefaultTemplates && this.isSettingsDirSet || !this.useDefaultTemplates && !this.isSettingsDirSet) {
            throw new RuntimeException("ERROR: must specify only ONE of: -use-default-templates , -settings-dir");
        }
        if (!this.useDefaultTemplates) {
            this.validateSettingsDir();
        }
        this.validateDocletStartingState();
        this.processDocs(rootDoc);
        return true;
    }

    protected boolean parseOption(String[] options) {
        boolean hasParsedOption = false;
        if (options[0].equals(SETTINGS_DIR_OPTION)) {
            settingsDir = new File(options[1]);
            this.isSettingsDirSet = true;
            hasParsedOption = true;
        } else if (options[0].equals(DESTINATION_DIR_OPTION)) {
            destinationDir = new File(options[1]);
            hasParsedOption = true;
        } else if (options[0].equals(BUILD_TIMESTAMP_OPTION)) {
            buildTimestamp = options[1];
            hasParsedOption = true;
        } else if (options[0].equals(ABSOLUTE_VERSION_OPTION)) {
            absoluteVersion = options[1];
            hasParsedOption = true;
        } else if (options[0].equals(INCLUDE_HIDDEN_OPTION)) {
            showHiddenFeatures = true;
            hasParsedOption = true;
        } else if (options[0].equals(OUTPUT_FILE_EXTENSION_OPTION)) {
            outputFileExtension = options[1];
            hasParsedOption = true;
        } else if (options[0].equals(INDEX_FILE_EXTENSION_OPTION)) {
            indexFileExtension = options[1];
            hasParsedOption = true;
        } else if (options[0].equals(USE_DEFAULT_TEMPLATES_OPTION)) {
            this.useDefaultTemplates = true;
            hasParsedOption = true;
        }
        return hasParsedOption;
    }

    public static int optionLength(String option) {
        if (option.equals(DOC_TITLE_OPTION) || option.equals(WINDOW_TITLE_OPTION) || option.equals(SETTINGS_DIR_OPTION) || option.equals(DESTINATION_DIR_OPTION) || option.equals(BUILD_TIMESTAMP_OPTION) || option.equals(ABSOLUTE_VERSION_OPTION) || option.equals(OUTPUT_FILE_EXTENSION_OPTION) || option.equals(INDEX_FILE_EXTENSION_OPTION)) {
            return 2;
        }
        if (option.equals(QUIET_OPTION) || option.equals(USE_DEFAULT_TEMPLATES_OPTION)) {
            return 1;
        }
        logger.error("The Javadoc command line option is not recognized by the Barclay doclet: " + option);
        return 0;
    }

    private void processDocs(RootDoc rootDoc) {
        this.rootDoc = rootDoc;
        this.workUnits = this.computeWorkUnits();
        HashSet uniqueGroups = new HashSet();
        ArrayList<Map<String, String>> featureMaps = new ArrayList<Map<String, String>>();
        ArrayList<Map<String, String>> groupMaps = new ArrayList<Map<String, String>>();
        this.workUnits.stream().forEach(workUnit -> {
            featureMaps.add(this.indexDataMap((DocWorkUnit)workUnit));
            if (!uniqueGroups.contains(workUnit.getGroupName())) {
                uniqueGroups.add(workUnit.getGroupName());
                groupMaps.add(this.getGroupMap((DocWorkUnit)workUnit));
            }
        });
        this.workUnits.stream().forEach(workUnit -> workUnit.processDoc(featureMaps, groupMaps));
        this.emitOutputFromTemplates(groupMaps, featureMaps);
    }

    private Set<DocWorkUnit> computeWorkUnits() {
        TreeSet<DocWorkUnit> workUnits = new TreeSet<DocWorkUnit>();
        for (ClassDoc classDoc : this.rootDoc.classes()) {
            Class<? extends Object> clazz = this.getClassForClassDoc(classDoc);
            DocumentedFeature documentedFeature = this.getDocumentedFeatureForClass(clazz);
            if (documentedFeature == null) continue;
            if (documentedFeature.enable() && this.includeInDocs(documentedFeature, classDoc, clazz)) {
                DocWorkUnit workUnit = this.createWorkUnit(documentedFeature, classDoc, clazz);
                if (workUnit == null) continue;
                workUnits.add(workUnit);
                continue;
            }
            logger.info("Skipping disabled documentation for feature: " + classDoc);
        }
        return workUnits;
    }

    public RootDoc getRootDoc() {
        return this.rootDoc;
    }

    public String getBuildTimeStamp() {
        return buildTimestamp;
    }

    public String getBuildVersion() {
        return absoluteVersion;
    }

    public boolean showHiddenFeatures() {
        return showHiddenFeatures;
    }

    public String getOutputFileExtension() {
        return outputFileExtension;
    }

    public String getIndexFileExtension() {
        return indexFileExtension;
    }

    public String getIndexTemplateName() {
        return "generic.index.html.ftl";
    }

    public String getIndexBaseFileName() {
        return "index";
    }

    public File getDestinationDir() {
        return destinationDir;
    }

    public boolean includeInDocs(DocumentedFeature documentedFeature, ClassDoc classDoc, Class<?> clazz) {
        boolean hidden = !this.showHiddenFeatures() && clazz.isAnnotationPresent(Hidden.class);
        return !hidden && JVMUtils.isConcrete(clazz);
    }

    private void emitOutputFromTemplates(List<Map<String, String>> groupMaps, List<Map<String, String>> featureMaps) {
        try {
            Configuration cfg = new Configuration(Configuration.VERSION_2_3_23);
            cfg.setObjectWrapper(new DefaultObjectWrapper(Configuration.VERSION_2_3_23));
            TemplateLoader templateLoader = this.useDefaultTemplates ? new ClassTemplateLoader(this.getClass(), DEFAULT_SETTINGS_CLASSPATH) : new FileTemplateLoader(new File(settingsDir.getPath()));
            cfg.setTemplateLoader(templateLoader);
            this.workUnits.stream().forEach(workUnit -> this.processWorkUnitTemplate(cfg, (DocWorkUnit)workUnit, groupMaps, featureMaps));
            this.processIndexTemplate(cfg, new ArrayList<DocWorkUnit>(this.workUnits), groupMaps);
        }
        catch (FileNotFoundException e) {
            throw new RuntimeException("FileNotFoundException processing javadoc template", e);
        }
        catch (IOException e) {
            throw new RuntimeException("IOException processing javadoc template", e);
        }
    }

    protected DocWorkUnit createWorkUnit(DocumentedFeature documentedFeature, ClassDoc classDoc, Class<?> clazz) {
        return new DocWorkUnit(new DefaultDocWorkUnitHandler(this), documentedFeature, classDoc, clazz);
    }

    private DocumentedFeature getDocumentedFeatureForClass(Class<?> clazz) {
        if (clazz != null && clazz.isAnnotationPresent(DocumentedFeature.class)) {
            return clazz.getAnnotation(DocumentedFeature.class);
        }
        return null;
    }

    private Class<? extends Object> getClassForClassDoc(ClassDoc doc) {
        try {
            return DocletUtils.getClassForDoc((ProgramElementDoc)doc);
        }
        catch (ClassNotFoundException e) {
            return null;
        }
        catch (NoClassDefFoundError e) {
            return null;
        }
        catch (UnsatisfiedLinkError e) {
            return null;
        }
    }

    protected void processIndexTemplate(Configuration cfg, List<DocWorkUnit> workUnitList, List<Map<String, String>> groupMaps) throws IOException {
        Template template = cfg.getTemplate(this.getIndexTemplateName());
        File indexFile = new File(this.getDestinationDir(), this.getIndexBaseFileName() + '.' + this.getIndexFileExtension());
        try (FileOutputStream fileOutStream = new FileOutputStream(indexFile);
             OutputStreamWriter outWriter = new OutputStreamWriter(fileOutStream);){
            template.process(this.groupIndexMap(workUnitList, groupMaps), outWriter);
        }
        catch (TemplateException e) {
            throw new DocException("Freemarker Template Exception during documentation index creation", e);
        }
    }

    protected Map<String, Object> groupIndexMap(List<DocWorkUnit> workUnitList, List<Map<String, String>> groupMaps) {
        HashMap<String, Object> root = new HashMap<String, Object>();
        Collections.sort(workUnitList);
        ArrayList data = new ArrayList();
        workUnitList.stream().forEach(workUnit -> data.add(this.indexDataMap((DocWorkUnit)workUnit)));
        root.put("data", data);
        root.put("groups", groupMaps);
        root.put("timestamp", this.getBuildTimeStamp());
        root.put("version", this.getBuildVersion());
        return root;
    }

    protected Map<String, String> getGroupMap(DocWorkUnit workUnit) {
        HashMap<String, String> propertyMap = new HashMap<String, String>();
        propertyMap.put("id", this.getGroupIdFromName(workUnit.getGroupName()));
        propertyMap.put("name", workUnit.getGroupName());
        propertyMap.put("summary", workUnit.getGroupSummary());
        return propertyMap;
    }

    private String getGroupIdFromName(String groupName) {
        return groupName.replaceAll("\\W", "");
    }

    public Map<String, String> indexDataMap(DocWorkUnit workUnit) {
        HashMap<String, String> propertyMap = new HashMap<String, String>();
        propertyMap.put("name", workUnit.getName());
        propertyMap.put("summary", workUnit.getSummary());
        propertyMap.put("filename", workUnit.getTargetFileName());
        propertyMap.put("group", workUnit.getGroupName());
        propertyMap.put("beta", Boolean.toString(workUnit.isBetaFeature()));
        propertyMap.put("experimental", Boolean.toString(workUnit.isExperimentalFeature()));
        return propertyMap;
    }

    public final DocWorkUnit findWorkUnitForClass(Class<?> c) {
        for (DocWorkUnit workUnit : this.workUnits) {
            if (!workUnit.getClazz().equals(c)) continue;
            return workUnit;
        }
        return null;
    }

    public ClassDoc getClassDocForClass(Class<?> clazz) {
        return this.rootDoc.classNamed(clazz.getName());
    }

    protected void processWorkUnitTemplate(Configuration cfg, DocWorkUnit workUnit, List<Map<String, String>> indexByGroupMaps, List<Map<String, String>> featureMaps) {
        Throwable throwable;
        try {
            Template template = cfg.getTemplate(workUnit.getTemplateName());
            File outputPath = new File(this.getDestinationDir(), workUnit.getTargetFileName());
            throwable = null;
            try (OutputStreamWriter out = new OutputStreamWriter(new FileOutputStream(outputPath));){
                template.process(workUnit.getRootMap(), out);
            }
            catch (Throwable throwable2) {
                throwable = throwable2;
                throw throwable2;
            }
        }
        catch (IOException e) {
            throw new DocException("IOException during documentation creation", e);
        }
        catch (TemplateException e) {
            throw new DocException("TemplateException during documentation creation", e);
        }
        GSONWorkUnit gsonworkunit = this.createGSONWorkUnit(workUnit, indexByGroupMaps, featureMaps);
        gsonworkunit.populate(workUnit.getProperty("summary").toString(), workUnit.getProperty("gson-arguments"), workUnit.getProperty("description").toString(), workUnit.getProperty("name").toString(), workUnit.getProperty("group").toString(), Boolean.valueOf(workUnit.getProperty("beta").toString()), Boolean.valueOf(workUnit.getProperty("experimental").toString()));
        File outputPathForJSON = new File(this.getDestinationDir(), workUnit.getJSONFileName());
        try {
            throwable = null;
            try (BufferedWriter jsonWriter = new BufferedWriter(new FileWriter(outputPathForJSON));){
                Gson gson = new GsonBuilder().serializeSpecialFloatingPointValues().setPrettyPrinting().create();
                String json = gson.toJson(gsonworkunit);
                jsonWriter.write(json);
            }
            catch (Throwable throwable3) {
                throwable = throwable3;
                throw throwable3;
            }
        }
        catch (IOException e) {
            throw new DocException("Failed to create JSON entry", e);
        }
    }

    protected GSONWorkUnit createGSONWorkUnit(DocWorkUnit workUnit, List<Map<String, String>> indexByGroupMaps, List<Map<String, String>> featureMaps) {
        return new GSONWorkUnit();
    }
}

