/*
 * Decompiled with CFR 0.152.
 */
package picard.analysis;

import com.google.common.annotations.VisibleForTesting;
import com.google.common.collect.Lists;
import htsjdk.samtools.AlignmentBlock;
import htsjdk.samtools.Cigar;
import htsjdk.samtools.CigarElement;
import htsjdk.samtools.CigarOperator;
import htsjdk.samtools.SAMReadGroupRecord;
import htsjdk.samtools.SAMRecord;
import htsjdk.samtools.SAMTag;
import htsjdk.samtools.SamPairUtil;
import htsjdk.samtools.metrics.MetricsFile;
import htsjdk.samtools.reference.ReferenceSequence;
import htsjdk.samtools.util.CoordMath;
import htsjdk.samtools.util.Histogram;
import htsjdk.samtools.util.SequenceUtil;
import java.util.List;
import java.util.Set;
import picard.analysis.AdapterUtility;
import picard.analysis.AlignmentSummaryMetrics;
import picard.analysis.ChimeraUtil;
import picard.analysis.MetricAccumulationLevel;
import picard.metrics.PerUnitMetricCollector;
import picard.metrics.SAMRecordAndReference;
import picard.metrics.SAMRecordAndReferenceMultiLevelCollector;
import picard.util.MathUtil;

public class AlignmentSummaryMetricsCollector
extends SAMRecordAndReferenceMultiLevelCollector<AlignmentSummaryMetrics, Integer> {
    private final boolean doRefMetrics;
    private final int maxInsertSize;
    private final Set<SamPairUtil.PairOrientation> expectedOrientations;
    private final boolean isBisulfiteSequenced;
    private final int MAPPING_QUALITY_THRESHOLD = 20;
    private static final int BASE_QUALITY_THRESHOLD = 20;
    private final AdapterUtility adapterUtility;

    public AlignmentSummaryMetricsCollector(Set<MetricAccumulationLevel> accumulationLevels, List<SAMReadGroupRecord> samRgRecords, boolean doRefMetrics, List<String> adapterSequence, int maxInsertSize, Set<SamPairUtil.PairOrientation> expectedOrientations, boolean isBisulfiteSequenced) {
        this.doRefMetrics = doRefMetrics;
        this.adapterUtility = new AdapterUtility(adapterSequence);
        this.maxInsertSize = maxInsertSize;
        this.expectedOrientations = expectedOrientations;
        this.isBisulfiteSequenced = isBisulfiteSequenced;
        this.setup(accumulationLevels, samRgRecords);
    }

    @Override
    protected PerUnitMetricCollector<AlignmentSummaryMetrics, Integer, SAMRecordAndReference> makeChildCollector(String sample, String library, String readGroup) {
        return new GroupAlignmentSummaryMetricsPerUnitMetricCollector(sample, library, readGroup);
    }

    @Override
    public void acceptRecord(SAMRecord rec, ReferenceSequence ref) {
        if (!rec.isSecondaryOrSupplementary()) {
            super.acceptRecord(rec, ref);
        }
    }

    private static int getTotalCigarOperatorCount(Cigar cigar, CigarOperator op) {
        return cigar.getCigarElements().stream().filter(e -> e.getOperator().equals((Object)op)).mapToInt(CigarElement::getLength).reduce(Integer::sum).orElse(0);
    }

    @VisibleForTesting
    protected static int get3PrimeSoftClippedBases(Cigar cigar, boolean negativeStrand) {
        List<CigarElement> cigarElements = !negativeStrand ? cigar.getCigarElements() : Lists.reverse(cigar.getCigarElements());
        boolean foundNonSoftClipOperator = false;
        int softclipsFound = 0;
        for (CigarElement cigarElement : cigarElements) {
            if (!cigarElement.getOperator().isClipping()) {
                foundNonSoftClipOperator = true;
                continue;
            }
            if (!foundNonSoftClipOperator || !cigarElement.getOperator().equals((Object)CigarOperator.SOFT_CLIP)) continue;
            softclipsFound += cigarElement.getLength();
        }
        return softclipsFound;
    }

    public class IndividualAlignmentSummaryMetricsCollector
    implements PerUnitMetricCollector<AlignmentSummaryMetrics, Integer, SAMRecordAndReference> {
        private long numPositiveStrand;
        private final Histogram<Integer> readLengthHistogram = new Histogram("count", "readLength");
        private final Histogram<Integer> alignedReadLengthHistogram = new Histogram("count", "alignedReadLength");
        private final AlignmentSummaryMetrics metrics;
        private long chimeras;
        private long chimerasDenominator;
        private long adapterReads;
        private long indels;
        private long numSoftClipped;
        private long num3PrimeSoftClippedBases;
        private long numReadsWith3PrimeSoftClips;
        private long numHardClipped;
        private long nonBisulfiteAlignedBases;
        private long hqNonBisulfiteAlignedBases;
        private final Histogram<Long> mismatchHistogram = new Histogram();
        private final Histogram<Long> hqMismatchHistogram = new Histogram();
        private final Histogram<Integer> badCycleHistogram = new Histogram();

        public IndividualAlignmentSummaryMetricsCollector(AlignmentSummaryMetrics.Category pairingCategory, String sample, String library, String readGroup) {
            this.metrics = new AlignmentSummaryMetrics();
            this.metrics.CATEGORY = pairingCategory;
            this.metrics.SAMPLE = sample;
            this.metrics.LIBRARY = library;
            this.metrics.READ_GROUP = readGroup;
        }

        @Override
        public void acceptRecord(SAMRecordAndReference samRecordAndReference) {
            SAMRecord record = samRecordAndReference.getSamRecord();
            ReferenceSequence ref = samRecordAndReference.getReferenceSequence();
            if (record.isSecondaryAlignment()) {
                return;
            }
            this.collectReadData(record);
            this.collectQualityData(record, ref);
        }

        @Override
        public void finish() {
            if (this.metrics.TOTAL_READS > 0L) {
                this.metrics.PCT_PF_READS = (double)this.metrics.PF_READS / (double)this.metrics.TOTAL_READS;
                this.metrics.PCT_ADAPTER = (double)this.adapterReads / (double)this.metrics.PF_READS;
                this.metrics.MEAN_READ_LENGTH = this.readLengthHistogram.getMean();
                this.metrics.BAD_CYCLES = 0L;
                for (Histogram.Bin<Integer> cycleBin : this.badCycleHistogram.values()) {
                    double badCyclePercentage = cycleBin.getValue() / (double)this.metrics.TOTAL_READS;
                    if (!(badCyclePercentage >= 0.8)) continue;
                    ++this.metrics.BAD_CYCLES;
                }
                if (AlignmentSummaryMetricsCollector.this.doRefMetrics) {
                    double totalBases = this.readLengthHistogram.getSum();
                    this.metrics.PCT_PF_READS_ALIGNED = MathUtil.divide(this.metrics.PF_READS_ALIGNED, this.metrics.PF_READS);
                    this.metrics.PCT_READS_ALIGNED_IN_PAIRS = MathUtil.divide(this.metrics.READS_ALIGNED_IN_PAIRS, this.metrics.PF_READS_ALIGNED);
                    this.metrics.PCT_PF_READS_IMPROPER_PAIRS = MathUtil.divide(this.metrics.PF_READS_IMPROPER_PAIRS, this.metrics.PF_READS_ALIGNED);
                    this.metrics.STRAND_BALANCE = MathUtil.divide(this.numPositiveStrand, this.metrics.PF_READS_ALIGNED);
                    this.metrics.PCT_CHIMERAS = MathUtil.divide(this.chimeras, this.chimerasDenominator);
                    this.metrics.PF_INDEL_RATE = MathUtil.divide(this.indels, this.metrics.PF_ALIGNED_BASES);
                    this.metrics.PF_MISMATCH_RATE = MathUtil.divide(this.mismatchHistogram.getSum(), this.nonBisulfiteAlignedBases);
                    this.metrics.PF_HQ_ERROR_RATE = MathUtil.divide(this.hqMismatchHistogram.getSum(), this.hqNonBisulfiteAlignedBases);
                    this.metrics.PCT_HARDCLIP = MathUtil.divide(this.numHardClipped, totalBases);
                    this.metrics.PCT_SOFTCLIP = MathUtil.divide(this.numSoftClipped, totalBases);
                    this.metrics.AVG_POS_3PRIME_SOFTCLIP_LENGTH = MathUtil.divide(this.num3PrimeSoftClippedBases, this.numReadsWith3PrimeSoftClips);
                    this.metrics.PF_HQ_MEDIAN_MISMATCHES = this.hqMismatchHistogram.getMedian();
                }
            }
        }

        @Override
        public void addMetricsToFile(MetricsFile<AlignmentSummaryMetrics, Integer> file) {
            file.addMetric(this.metrics);
        }

        private int getUnclippedBaseCount(Cigar cigar) {
            return cigar.getCigarElements().stream().filter(e -> e.getOperator().consumesReadBases()).filter(e -> !e.getOperator().isClipping()).mapToInt(CigarElement::getLength).reduce(Integer::sum).orElse(0);
        }

        private void collectReadData(SAMRecord record) {
            if (record.getSupplementaryAlignmentFlag()) {
                return;
            }
            ++this.metrics.TOTAL_READS;
            if (!record.getReadFailsVendorQualityCheckFlag()) {
                ++this.metrics.PF_READS;
                if (this.isNoiseRead(record)) {
                    ++this.metrics.PF_NOISE_READS;
                }
                this.readLengthHistogram.increment(record.getReadBases().length);
                this.alignedReadLengthHistogram.increment(this.getUnclippedBaseCount(record.getCigar()));
                if (AlignmentSummaryMetricsCollector.this.adapterUtility.isAdapter(record)) {
                    ++this.adapterReads;
                }
                this.numHardClipped += (long)AlignmentSummaryMetricsCollector.getTotalCigarOperatorCount(record.getCigar(), CigarOperator.HARD_CLIP);
                if (!record.getReadUnmappedFlag()) {
                    this.numSoftClipped += (long)AlignmentSummaryMetricsCollector.getTotalCigarOperatorCount(record.getCigar(), CigarOperator.SOFT_CLIP);
                    int threePrimeSoftClippedBases = AlignmentSummaryMetricsCollector.get3PrimeSoftClippedBases(record.getCigar(), record.getReadNegativeStrandFlag());
                    if (threePrimeSoftClippedBases > 0) {
                        this.num3PrimeSoftClippedBases += (long)threePrimeSoftClippedBases;
                        ++this.numReadsWith3PrimeSoftClips;
                    }
                    if (AlignmentSummaryMetricsCollector.this.doRefMetrics) {
                        ++this.metrics.PF_READS_ALIGNED;
                        if (record.getReadPairedFlag() && !record.getProperPairFlag()) {
                            ++this.metrics.PF_READS_IMPROPER_PAIRS;
                        }
                        if (!record.getReadNegativeStrandFlag()) {
                            ++this.numPositiveStrand;
                        }
                        if (record.getReadPairedFlag() && !record.getMateUnmappedFlag()) {
                            ++this.metrics.READS_ALIGNED_IN_PAIRS;
                            Integer mateMq = record.getIntegerAttribute(SAMTag.MQ.toString());
                            if (mateMq == null || mateMq >= 20 && record.getMappingQuality() >= 20) {
                                ++this.chimerasDenominator;
                                if (ChimeraUtil.isChimeric(record, AlignmentSummaryMetricsCollector.this.maxInsertSize, AlignmentSummaryMetricsCollector.this.expectedOrientations)) {
                                    ++this.chimeras;
                                }
                            }
                        } else if (record.getMappingQuality() >= 20) {
                            ++this.chimerasDenominator;
                            if (record.getAttribute(SAMTag.SA.toString()) != null) {
                                ++this.chimeras;
                            }
                        }
                    }
                }
            }
        }

        private void collectQualityData(SAMRecord record, ReferenceSequence reference) {
            block12: {
                block11: {
                    if (!record.getReadUnmappedFlag() && !record.getReadFailsVendorQualityCheckFlag() && AlignmentSummaryMetricsCollector.this.doRefMetrics) break block11;
                    byte[] readBases = record.getReadBases();
                    for (int i = 0; i < readBases.length; ++i) {
                        if (!SequenceUtil.isNoCall(readBases[i])) continue;
                        this.badCycleHistogram.increment(CoordMath.getCycle(record.getReadNegativeStrandFlag(), readBases.length, i));
                    }
                    break block12;
                }
                if (record.getReadFailsVendorQualityCheckFlag()) break block12;
                boolean highQualityMapping = this.isHighQualityMapping(record);
                if (highQualityMapping && !record.getSupplementaryAlignmentFlag()) {
                    ++this.metrics.PF_HQ_ALIGNED_READS;
                }
                byte[] readBases = record.getReadBases();
                byte[] refBases = reference == null ? null : reference.getBases();
                int refLength = reference == null ? Integer.MAX_VALUE : refBases.length;
                byte[] qualities = record.getBaseQualities();
                long mismatchCount = 0L;
                long hqMismatchCount = 0L;
                for (AlignmentBlock alignmentBlock : record.getAlignmentBlocks()) {
                    int readIndex = alignmentBlock.getReadStart() - 1;
                    int refIndex = alignmentBlock.getReferenceStart() - 1;
                    int length = alignmentBlock.getLength();
                    for (int i = 0; i < length && refIndex + i < refLength; ++i) {
                        int readBaseIndex = readIndex + i;
                        boolean mismatch = refBases != null && !SequenceUtil.basesEqual(readBases[readBaseIndex], refBases[refIndex + i]);
                        boolean bisulfiteMatch = refBases != null && AlignmentSummaryMetricsCollector.this.isBisulfiteSequenced && SequenceUtil.bisulfiteBasesEqual(record.getReadNegativeStrandFlag(), readBases[readBaseIndex], refBases[readBaseIndex]);
                        boolean bisulfiteBase = mismatch && bisulfiteMatch;
                        boolean bl = mismatch = mismatch && !bisulfiteMatch;
                        if (mismatch) {
                            ++mismatchCount;
                        }
                        ++this.metrics.PF_ALIGNED_BASES;
                        if (!bisulfiteBase) {
                            ++this.nonBisulfiteAlignedBases;
                        }
                        if (highQualityMapping) {
                            ++this.metrics.PF_HQ_ALIGNED_BASES;
                            if (!bisulfiteBase) {
                                ++this.hqNonBisulfiteAlignedBases;
                            }
                            if (qualities[readBaseIndex] >= 20) {
                                ++this.metrics.PF_HQ_ALIGNED_Q20_BASES;
                            }
                            if (mismatch) {
                                ++hqMismatchCount;
                            }
                        }
                        if (!mismatch && !SequenceUtil.isNoCall(readBases[readBaseIndex])) continue;
                        this.badCycleHistogram.increment(CoordMath.getCycle(record.getReadNegativeStrandFlag(), readBases.length, i));
                    }
                }
                this.mismatchHistogram.increment(mismatchCount);
                this.hqMismatchHistogram.increment(hqMismatchCount);
                for (CigarElement elem : record.getCigar().getCigarElements()) {
                    CigarOperator op = elem.getOperator();
                    if (op != CigarOperator.INSERTION && op != CigarOperator.DELETION) continue;
                    ++this.indels;
                }
            }
        }

        private boolean isNoiseRead(SAMRecord record) {
            Object noiseAttribute = record.getAttribute("XN");
            return noiseAttribute != null && noiseAttribute.equals(1);
        }

        private boolean isHighQualityMapping(SAMRecord record) {
            return !record.getReadFailsVendorQualityCheckFlag() && record.getMappingQuality() >= 20;
        }

        public AlignmentSummaryMetrics getMetrics() {
            return this.metrics;
        }

        public Histogram<Integer> getReadHistogram() {
            return this.readLengthHistogram;
        }

        public Histogram<Integer> getAlignedReadHistogram() {
            return this.alignedReadLengthHistogram;
        }
    }

    public class GroupAlignmentSummaryMetricsPerUnitMetricCollector
    implements PerUnitMetricCollector<AlignmentSummaryMetrics, Integer, SAMRecordAndReference> {
        final IndividualAlignmentSummaryMetricsCollector unpairedCollector;
        final IndividualAlignmentSummaryMetricsCollector firstOfPairCollector;
        final IndividualAlignmentSummaryMetricsCollector secondOfPairCollector;
        final IndividualAlignmentSummaryMetricsCollector pairCollector;
        final String sample;
        final String library;
        final String readGroup;

        public GroupAlignmentSummaryMetricsPerUnitMetricCollector(String sample, String library, String readGroup) {
            this.sample = sample;
            this.library = library;
            this.readGroup = readGroup;
            this.unpairedCollector = new IndividualAlignmentSummaryMetricsCollector(AlignmentSummaryMetrics.Category.UNPAIRED, sample, library, readGroup);
            this.firstOfPairCollector = new IndividualAlignmentSummaryMetricsCollector(AlignmentSummaryMetrics.Category.FIRST_OF_PAIR, sample, library, readGroup);
            this.secondOfPairCollector = new IndividualAlignmentSummaryMetricsCollector(AlignmentSummaryMetrics.Category.SECOND_OF_PAIR, sample, library, readGroup);
            this.pairCollector = new IndividualAlignmentSummaryMetricsCollector(AlignmentSummaryMetrics.Category.PAIR, sample, library, readGroup);
        }

        @Override
        public void acceptRecord(SAMRecordAndReference args) {
            if (args.getSamRecord().getReadPairedFlag()) {
                if (args.getSamRecord().getFirstOfPairFlag()) {
                    this.firstOfPairCollector.acceptRecord(args);
                } else {
                    this.secondOfPairCollector.acceptRecord(args);
                }
                this.pairCollector.acceptRecord(args);
            } else {
                this.unpairedCollector.acceptRecord(args);
            }
        }

        @Override
        public void finish() {
            this.unpairedCollector.finish();
            this.firstOfPairCollector.finish();
            this.secondOfPairCollector.finish();
            this.pairCollector.finish();
        }

        @Override
        public void addMetricsToFile(MetricsFile<AlignmentSummaryMetrics, Integer> file) {
            if (this.firstOfPairCollector.getMetrics().TOTAL_READS > 0L) {
                this.pairCollector.getMetrics().BAD_CYCLES = this.firstOfPairCollector.getMetrics().BAD_CYCLES + this.secondOfPairCollector.getMetrics().BAD_CYCLES;
                this.firstOfPairCollector.addMetricsToFile(file);
                this.secondOfPairCollector.addMetricsToFile(file);
                this.pairCollector.addMetricsToFile(file);
            }
            if (this.unpairedCollector.getMetrics().TOTAL_READS > 0L || this.firstOfPairCollector.getMetrics().TOTAL_READS == 0L) {
                this.unpairedCollector.addMetricsToFile(file);
            }
        }
    }
}

