/*
 * Decompiled with CFR 0.152.
 */
package picard.analysis;

import htsjdk.samtools.metrics.MetricsFile;
import htsjdk.samtools.reference.ReferenceSequence;
import htsjdk.samtools.reference.ReferenceSequenceFileWalker;
import htsjdk.samtools.util.AbstractLocusInfo;
import htsjdk.samtools.util.AbstractLocusIterator;
import htsjdk.samtools.util.AbstractRecordAndOffset;
import htsjdk.samtools.util.Log;
import htsjdk.samtools.util.ProgressLogger;
import java.util.Arrays;
import java.util.stream.LongStream;
import picard.analysis.AbstractWgsMetricsCollector;
import picard.analysis.WgsMetrics;
import picard.analysis.WgsMetricsProcessor;
import picard.filter.CountingFilter;
import picard.filter.CountingPairedFilter;

public class WgsMetricsProcessorImpl<T extends AbstractRecordAndOffset>
implements WgsMetricsProcessor {
    private final AbstractLocusIterator<T, AbstractLocusInfo<T>> iterator;
    private final AbstractWgsMetricsCollector<T> collector;
    private final ReferenceSequenceFileWalker refWalker;
    private final ProgressLogger progress;
    private final Log log = Log.getInstance(WgsMetricsProcessorImpl.class);

    public WgsMetricsProcessorImpl(AbstractLocusIterator<T, AbstractLocusInfo<T>> iterator, ReferenceSequenceFileWalker refWalker, AbstractWgsMetricsCollector<T> collector, ProgressLogger progress) {
        this.iterator = iterator;
        this.collector = collector;
        this.refWalker = refWalker;
        this.progress = progress;
    }

    @Override
    public void processFile() {
        long sumDepthHisto;
        long sumBaseQ;
        long counter = 0L;
        while (this.iterator.hasNext()) {
            Object info = this.iterator.next();
            ReferenceSequence ref = this.refWalker.get(((AbstractLocusInfo)info).getSequenceIndex());
            boolean referenceBaseN = this.collector.isReferenceBaseN(((AbstractLocusInfo)info).getPosition(), ref);
            this.collector.addInfo((AbstractLocusInfo<T>)info, ref, referenceBaseN);
            if (referenceBaseN) continue;
            this.progress.record(((AbstractLocusInfo)info).getSequenceName(), ((AbstractLocusInfo)info).getPosition());
            if (this.collector.isTimeToStop(++counter)) break;
            this.collector.setCounter(counter);
        }
        if ((sumBaseQ = Arrays.stream(this.collector.unfilteredBaseQHistogramArray).sum()) != (sumDepthHisto = LongStream.rangeClosed(0L, this.collector.coverageCap).map(i -> i * this.collector.unfilteredDepthHistogramArray[(int)i]).sum())) {
            this.log.error("Coverage and baseQ distributions contain different amount of bases!");
        }
    }

    @Override
    public void addToMetricsFile(MetricsFile<WgsMetrics, Integer> file, boolean includeBQHistogram, CountingFilter dupeFilter, CountingFilter adapterFilter, CountingFilter mapqFilter, CountingPairedFilter pairFilter) {
        this.collector.addToMetricsFile(file, includeBQHistogram, dupeFilter, adapterFilter, mapqFilter, pairFilter);
    }
}

