/*
 * Decompiled with CFR 0.152.
 */
package picard.analysis.directed;

import htsjdk.samtools.SAMReadGroupRecord;
import htsjdk.samtools.reference.ReferenceSequenceFile;
import htsjdk.samtools.util.IntervalList;
import java.io.File;
import java.util.List;
import java.util.Set;
import picard.analysis.MetricAccumulationLevel;
import picard.analysis.directed.TargetMetrics;
import picard.analysis.directed.TargetMetricsCollector;
import picard.analysis.directed.TargetedPcrMetrics;

public class TargetedPcrMetricsCollector
extends TargetMetricsCollector<TargetedPcrMetrics> {
    public TargetedPcrMetricsCollector(Set<MetricAccumulationLevel> accumulationLevels, List<SAMReadGroupRecord> samRgRecords, ReferenceSequenceFile refFile, File perTargetCoverage, File perBaseCoverage, IntervalList targetIntervals, IntervalList probeIntervals, String probeSetName, int nearProbeDistance, int minimumMappingQuality, int minimumBaseQuality, boolean clipOverlappingReads, int coverageCap, int sampleSize) {
        super(accumulationLevels, samRgRecords, refFile, perTargetCoverage, perBaseCoverage, targetIntervals, probeIntervals, probeSetName, nearProbeDistance, minimumMappingQuality, minimumBaseQuality, clipOverlappingReads, coverageCap, sampleSize);
    }

    public TargetedPcrMetricsCollector(Set<MetricAccumulationLevel> accumulationLevels, List<SAMReadGroupRecord> samRgRecords, ReferenceSequenceFile refFile, File perTargetCoverage, File perBaseCoverage, IntervalList targetIntervals, IntervalList probeIntervals, String probeSetName, int nearProbeDistance, int minimumMappingQuality, int minimumBaseQuality, boolean clipOverlappingReads, boolean noSideEffects, boolean includeIndels, int coverageCap, int sampleSize) {
        super(accumulationLevels, samRgRecords, refFile, perTargetCoverage, perBaseCoverage, targetIntervals, probeIntervals, probeSetName, nearProbeDistance, minimumMappingQuality, minimumBaseQuality, clipOverlappingReads, noSideEffects, includeIndels, coverageCap, sampleSize);
    }

    @Override
    public TargetedPcrMetrics convertMetric(TargetMetrics targetMetrics) {
        TargetedPcrMetrics pcrMetrics = new TargetedPcrMetrics();
        TargetMetricsCollector.reflectiveCopy(targetMetrics, pcrMetrics, new String[]{"PROBE_SET", "PROBE_TERRITORY", "ON_PROBE_BASES", "NEAR_PROBE_BASES", "OFF_PROBE_BASES", "PCT_SELECTED_BASES", "PCT_OFF_PROBE", "ON_PROBE_VS_SELECTED", "MEAN_PROBE_COVERAGE"}, new String[]{"CUSTOM_AMPLICON_SET", "AMPLICON_TERRITORY", "ON_AMPLICON_BASES", "NEAR_AMPLICON_BASES", "OFF_AMPLICON_BASES", "PCT_AMPLIFIED_BASES", "PCT_OFF_AMPLICON", "ON_AMPLICON_VS_SELECTED", "MEAN_AMPLICON_COVERAGE"});
        return pcrMetrics;
    }
}

