/*
 * Decompiled with CFR 0.152.
 */
package picard.arrays;

import htsjdk.samtools.SAMSequenceDictionary;
import htsjdk.samtools.util.CloseableIterator;
import htsjdk.samtools.util.IOUtil;
import htsjdk.samtools.util.Log;
import htsjdk.samtools.util.ProgressLogger;
import htsjdk.variant.variantcontext.Allele;
import htsjdk.variant.variantcontext.GenotypesContext;
import htsjdk.variant.variantcontext.VariantContext;
import htsjdk.variant.variantcontext.VariantContextBuilder;
import htsjdk.variant.variantcontext.VariantContextUtils;
import htsjdk.variant.variantcontext.writer.Options;
import htsjdk.variant.variantcontext.writer.VariantContextWriter;
import htsjdk.variant.variantcontext.writer.VariantContextWriterBuilder;
import htsjdk.variant.vcf.VCFFileReader;
import htsjdk.variant.vcf.VCFHeader;
import htsjdk.variant.vcf.VCFHeaderLine;
import htsjdk.variant.vcf.VCFUtils;
import java.io.File;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.TreeMap;
import java.util.TreeSet;
import org.broadinstitute.barclay.argparser.Argument;
import org.broadinstitute.barclay.argparser.CommandLineProgramProperties;
import org.broadinstitute.barclay.help.DocumentedFeature;
import picard.PicardException;
import picard.cmdline.CommandLineProgram;
import picard.cmdline.programgroups.GenotypingArraysProgramGroup;

@CommandLineProgramProperties(summary="CombineGenotypingArrayVcfs takes one or more VCF files, as generated by GtcToVcf and combines them into a single VCF. The input VCFs must have the same sequence dictionary and same list of variant loci. The input VCFs must not share sample Ids. <h4>Usage example:</h4><pre>java -jar picard.jar CombineGenotypingArrayVcfs \\<br />      INPUT=input1.vcf \\<br />      INPUT=input2.vcf \\<br />      OUTPUT=output.vcf</pre>", oneLineSummary="Program to combine multiple genotyping array VCF files into one VCF.", programGroup=GenotypingArraysProgramGroup.class)
@DocumentedFeature
public class CombineGenotypingArrayVcfs
extends CommandLineProgram {
    static final String USAGE_DETAILS = "CombineGenotypingArrayVcfs takes one or more VCF files, as generated by GtcToVcf and combines them into a single VCF. The input VCFs must have the same sequence dictionary and same list of variant loci. The input VCFs must not share sample Ids. <h4>Usage example:</h4><pre>java -jar picard.jar CombineGenotypingArrayVcfs \\<br />      INPUT=input1.vcf \\<br />      INPUT=input2.vcf \\<br />      OUTPUT=output.vcf</pre>";
    @Argument(shortName="I", doc="Input VCF file(s).")
    public List<File> INPUT;
    @Argument(shortName="O", doc="Output VCF file.")
    public File OUTPUT;
    private final Log log = Log.getInstance(CombineGenotypingArrayVcfs.class);
    private final ProgressLogger progressLogger = new ProgressLogger(this.log, 10000);
    private final Set<String> sampleSpecificHeaders = new HashSet<String>(Arrays.asList("pipelineVersion", "analysisVersionNumber", "autocallDate", "autocallGender", "chipWellBarcode", "expectedGender", "fingerprintGender", "gtcCallRate", "imagingDate", "p95Green", "p95Red", "sampleAlias", "scannerName", "Biotin(Bgnd)", "Biotin(High)", "DNP(Bgnd)", "DNP(High)", "Extension(A)", "Extension(C)", "Extension(G)", "Extension(T)", "Hyb(High)", "Hyb(Low)", "Hyb(Medium)", "NP(A)", "NP(C)", "NP(G)", "NP(T)", "NSB(Bgnd)Blue", "NSB(Bgnd)Green", "NSB(Bgnd)Purple", "NSB(Bgnd)Red", "Restore", "String(MM)", "String(PM)", "TargetRemoval", "fileDate"));

    public CombineGenotypingArrayVcfs() {
        this.CREATE_INDEX = true;
    }

    @Override
    public int doWork() {
        this.log.info("Checking inputs.");
        List<File> UNROLLED_INPUT = IOUtil.unrollFiles(this.INPUT, IOUtil.VCF_EXTENSIONS);
        IOUtil.assertFilesAreReadable(UNROLLED_INPUT);
        IOUtil.assertFileIsWritable(this.OUTPUT);
        SAMSequenceDictionary sequenceDictionary = VCFFileReader.getSequenceDictionary(UNROLLED_INPUT.get(0));
        ArrayList<String> sampleList = new ArrayList<String>();
        ArrayList<Iterator> iteratorCollection = new ArrayList<Iterator>(UNROLLED_INPUT.size());
        HashSet<VCFHeader> headers = new HashSet<VCFHeader>(UNROLLED_INPUT.size());
        HashSet<String> sampleNames = new HashSet<String>();
        for (File file : UNROLLED_INPUT) {
            VCFFileReader fileReader = new VCFFileReader(file, false);
            VCFHeader fileHeader = fileReader.getFileHeader();
            for (String sampleName : fileHeader.getSampleNamesInOrder()) {
                if (!sampleNames.add(sampleName)) {
                    throw new IllegalArgumentException("Input file " + file.getAbsolutePath() + " contains a sample entry (" + sampleName + ") that appears in another input file.");
                }
                sampleList.add(sampleName);
            }
            headers.add(fileHeader);
            iteratorCollection.add(fileReader.iterator());
        }
        if (this.CREATE_INDEX.booleanValue() && sequenceDictionary == null) {
            throw new PicardException("A sequence dictionary must be available (either through the input file or by setting it explicitly) when creating indexed output.");
        }
        VariantContextWriterBuilder builder = new VariantContextWriterBuilder().setOutputFile(this.OUTPUT).setReferenceDictionary(sequenceDictionary);
        if (this.CREATE_INDEX.booleanValue()) {
            builder.setOption(Options.INDEX_ON_THE_FLY);
        }
        try (VariantContextWriter writer = builder.build();){
            Set<VCFHeaderLine> headerLines = VCFUtils.smartMergeHeaders(headers, false);
            headerLines.removeIf(line -> this.sampleSpecificHeaders.contains(line.getKey()));
            writer.writeHeader(new VCFHeader(headerLines, sampleList));
            int closedIteratorCount = 0;
            while (closedIteratorCount == 0) {
                ArrayList<VariantContext> variantContexts = new ArrayList<VariantContext>();
                for (CloseableIterator closeableIterator : iteratorCollection) {
                    if (closeableIterator.hasNext()) {
                        variantContexts.add((VariantContext)closeableIterator.next());
                        continue;
                    }
                    ++closedIteratorCount;
                }
                if (closedIteratorCount != 0) continue;
                this.progressLogger.record(((VariantContext)variantContexts.get(0)).getContig(), ((VariantContext)variantContexts.get(0)).getStart());
                writer.add(CombineGenotypingArrayVcfs.merge(variantContexts));
            }
            if (closedIteratorCount != iteratorCollection.size()) {
                throw new PicardException("Mismatch in number of variants among input VCFs");
            }
        }
        return 0;
    }

    public static VariantContext merge(List<VariantContext> variantContexts) {
        if (variantContexts == null || variantContexts.isEmpty()) {
            return null;
        }
        VariantContext first = variantContexts.get(0);
        String name = first.getSource();
        HashSet<String> filters = new HashSet<String>();
        int depth = 0;
        double log10PError = 1.0;
        boolean anyVCHadFiltersApplied = false;
        GenotypesContext genotypes = GenotypesContext.create();
        Map<String, Object> firstAttributes = first.getAttributes();
        for (VariantContext vc : variantContexts) {
            if (vc.getStart() != first.getStart() || !vc.getContig().equals(first.getContig())) {
                throw new PicardException("Mismatch in loci among input VCFs");
            }
            if (!vc.getID().equals(first.getID())) {
                throw new PicardException("Mismatch in ID field among input VCFs");
            }
            if (!vc.getReference().equals(first.getReference())) {
                throw new PicardException("Mismatch in REF allele among input VCFs");
            }
            CombineGenotypingArrayVcfs.checkThatAllelesMatch(vc, first);
            genotypes.addAll(vc.getGenotypes());
            if (log10PError == 1.0) {
                log10PError = vc.getLog10PError();
            }
            filters.addAll(vc.getFilters());
            anyVCHadFiltersApplied |= vc.filtersWereApplied();
            if (vc.hasAttribute("DP")) {
                depth += vc.getAttributeAsInt("DP", 0);
            }
            for (Map.Entry<String, Object> p : vc.getAttributes().entrySet()) {
                String key = p.getKey();
                if (key.equals("AC") || key.equals("AF") || key.equals("AN") || key.equals("devX_AB") || key.equals("devY_AB")) continue;
                Object value = p.getValue();
                Object extantValue = firstAttributes.get(key);
                if (extantValue == null) {
                    throw new PicardException("Attribute '" + key + "' not found in all VCFs");
                }
                if (extantValue.equals(value)) continue;
                throw new PicardException("Values for attribute '" + key + "' disagrees among input VCFs");
            }
        }
        if (depth > 0) {
            firstAttributes.put("DP", String.valueOf(depth));
        }
        VariantContextBuilder builder = new VariantContextBuilder().source(name).id(first.getID());
        builder.loc(first.getContig(), first.getStart(), first.getEnd());
        builder.alleles((Collection<Allele>)first.getAlleles());
        builder.genotypes(genotypes);
        builder.attributes(new TreeMap<String, Object>(firstAttributes));
        VariantContextUtils.calculateChromosomeCounts(builder, false);
        builder.log10PError(log10PError);
        if (anyVCHadFiltersApplied) {
            builder.filters(filters.isEmpty() ? filters : new TreeSet(filters));
        }
        return builder.make();
    }

    private static void checkThatAllelesMatch(VariantContext vc1, VariantContext vc2) {
        if (!vc1.getReference().equals(vc2.getReference())) {
            throw new PicardException("Mismatch in REF allele among input VCFs");
        }
        if (vc1.getAlternateAlleles().size() != vc2.getAlternateAlleles().size()) {
            throw new PicardException("Mismatch in ALT allele count among input VCFs");
        }
        for (int i = 0; i < vc1.getAlternateAlleles().size(); ++i) {
            if (vc1.getAlternateAllele(i).equals(vc2.getAlternateAllele(i))) continue;
            throw new PicardException("Mismatch in ALT allele among input VCFs for " + vc1.getContig() + "." + vc1.getStart());
        }
    }
}

