/*
 * Decompiled with CFR 0.152.
 */
package picard.arrays.illumina;

import java.io.DataInputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.util.HashMap;
import java.util.Map;
import org.apache.commons.io.IOUtils;
import picard.PicardException;
import picard.arrays.illumina.InfiniumDataFile;
import picard.arrays.illumina.InfiniumVcfFields;

public class InfiniumEGTFile
extends InfiniumDataFile
implements AutoCloseable {
    public static final String EXTENSION = "egt";
    private static final int VALID_GENTRAIN_DATA_TYPE = 9;
    private static final int INVALID_FILE_VERSION = 2;
    public String gencallVersion;
    public String clusterVersion;
    public String callVersion;
    public String normalizationVersion;
    public String dateCreated;
    public boolean isWGT;
    public int[][] n;
    public float[][] meanR;
    public float[][] meanTheta;
    public float[][] devR;
    public float[][] devTheta;
    public float[] totalScore;
    public String[] rsNames;
    public String manifestName;
    public int numCodes;
    public Map<String, Integer> rsNameToIndex;

    public InfiniumEGTFile(File clusterFile) throws IOException {
        super(new DataInputStream(new FileInputStream(clusterFile)), false);
        this.parse();
    }

    @Override
    public void close() throws IOException {
        this.stream.close();
    }

    private void parse() throws IOException {
        try {
            this.readHeaderData();
            this.readFileData();
        }
        finally {
            IOUtils.closeQuietly(this.stream);
        }
    }

    private void readFileData() throws IOException {
        int i;
        int version = this.parseInt();
        if (version > 9) {
            throw new IOException("Error. Cannot read file - unknown version " + version + " for gentrain data type");
        }
        this.manifestName = this.parseString();
        this.numCodes = this.parseInt();
        this.initializeArrays(this.numCodes);
        for (i = 0; i < this.numCodes; ++i) {
            this.parseInts(this.n[i]);
            this.parseFloats(this.devR[i]);
            this.parseFloats(this.meanR[i]);
            this.parseFloats(this.devTheta[i]);
            this.parseFloats(this.meanTheta[i]);
            this.skipFloats(15);
        }
        for (i = 0; i < this.numCodes; ++i) {
            this.skipFloat();
            this.totalScore[i] = this.parseFloat();
            this.skipFloat();
            this.skipBoolean();
        }
        for (i = 0; i < this.numCodes; ++i) {
            this.skipString();
        }
        for (i = 0; i < this.numCodes; ++i) {
            this.rsNames[i] = this.parseString();
            if (this.rsNameToIndex.put(this.rsNames[i], i) == null) continue;
            throw new PicardException("Non-unique rsName '" + this.rsNames[i] + "' found in cluster file");
        }
    }

    private void initializeArrays(int numCodes) {
        this.n = new int[numCodes][InfiniumVcfFields.NUM_GENOTYPE_VALUES];
        this.devR = new float[numCodes][InfiniumVcfFields.NUM_GENOTYPE_VALUES];
        this.meanR = new float[numCodes][InfiniumVcfFields.NUM_GENOTYPE_VALUES];
        this.devTheta = new float[numCodes][InfiniumVcfFields.NUM_GENOTYPE_VALUES];
        this.meanTheta = new float[numCodes][InfiniumVcfFields.NUM_GENOTYPE_VALUES];
        this.totalScore = new float[numCodes];
        this.rsNames = new String[numCodes];
        this.rsNameToIndex = new HashMap<String, Integer>();
    }

    private void parseInts(int[] array) throws IOException {
        for (int i = 0; i < array.length; ++i) {
            array[i] = this.parseInt();
        }
    }

    private void parseFloats(float[] array) throws IOException {
        for (int i = 0; i < array.length; ++i) {
            array[i] = this.parseFloat();
        }
    }

    private void readHeaderData() throws IOException {
        this.setFileVersion(this.parseInt());
        this.gencallVersion = this.parseString();
        this.clusterVersion = this.parseString();
        this.callVersion = this.parseString();
        this.normalizationVersion = this.parseString();
        this.dateCreated = this.parseString();
        boolean bl = this.isWGT = this.parseByte() != 0;
        if (this.getFileVersion() == 2) {
            throw new IOException("Version '2' unsupported");
        }
        this.manifestName = this.parseString();
    }

    public String getManifestName() {
        return this.manifestName;
    }
}

