/*
 * Decompiled with CFR 0.152.
 */
package picard.filter;

import htsjdk.samtools.AlignmentBlock;
import htsjdk.samtools.SAMRecord;
import htsjdk.samtools.filter.SamRecordFilter;

public abstract class CountingFilter
implements SamRecordFilter {
    private long filteredRecords = 0L;
    private long filteredBases = 0L;

    public long getFilteredRecords() {
        return this.filteredRecords;
    }

    public long getFilteredBases() {
        return this.filteredBases;
    }

    @Override
    public final boolean filterOut(SAMRecord record) {
        boolean filteredOut = this.reallyFilterOut(record);
        if (filteredOut) {
            ++this.filteredRecords;
            for (AlignmentBlock block : record.getAlignmentBlocks()) {
                this.filteredBases += (long)block.getLength();
            }
        }
        return filteredOut;
    }

    public abstract boolean reallyFilterOut(SAMRecord var1);

    @Override
    public boolean filterOut(SAMRecord first, SAMRecord second) {
        throw new UnsupportedOperationException();
    }
}

