/*
 * Decompiled with CFR 0.152.
 */
package picard.fingerprint;

import htsjdk.samtools.metrics.MetricsFile;
import htsjdk.samtools.util.IOUtil;
import htsjdk.tribble.util.MathUtils;
import java.io.File;
import java.nio.file.Path;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.concurrent.TimeUnit;
import java.util.stream.Collectors;
import java.util.stream.IntStream;
import org.apache.commons.math3.random.MersenneTwister;
import org.apache.commons.math3.random.RandomDataGenerator;
import org.apache.commons.math3.random.RandomGenerator;
import org.apache.commons.math3.stat.inference.ChiSquareTest;
import org.broadinstitute.barclay.argparser.Argument;
import org.broadinstitute.barclay.argparser.CommandLineProgramProperties;
import org.broadinstitute.barclay.help.DocumentedFeature;
import picard.cmdline.CommandLineProgram;
import picard.cmdline.programgroups.DiagnosticsAndQCProgramGroup;
import picard.fingerprint.CrosscheckMetric;
import picard.fingerprint.Fingerprint;
import picard.fingerprint.FingerprintChecker;
import picard.fingerprint.FingerprintIdDetails;
import picard.fingerprint.FingerprintMetrics;
import picard.fingerprint.HaplotypeBlock;
import picard.fingerprint.HaplotypeProbabilities;
import picard.fingerprint.HaplotypeProbabilitiesFromGenotypeLikelihoods;
import picard.util.MathUtil;

@CommandLineProgramProperties(summary="Calculate statistics on fingerprints, checking their viabilityThis tools collects various statistics that pertain to a single fingerprint (<b>not</b> the comparison, or 'fingerprinting' of two distinct samples) and reports the results in a metrics file. <p>The statistics collected are p-values, where the null-hypothesis is that the fingerprint is collected from a non-contaminated, diploid human, whose genotypes are modelled by the probabilities given in the HAPLOTYPE_MAP file.<p>Please see the FingerprintMetrics <a href='http://broadinstitute.github.io/picard/picard-metric-definitions.html#FingerprintMetrics'>definitions</a> for a complete description of the metrics produced by this tool.</p><hr /><p><h3>Example</h3>\n<pre>\" +\njava -jar picard.jar CalculateFingerprintMetrics \\\n      INPUT=sample.bam \\\n      HAPLOTYPE_MAP=fingerprinting_haplotype_database.txt \\\n      OUTPUT=sample.fingerprint_metrics\n </pre>\n", oneLineSummary="Calculate statistics on fingerprints, checking their viability", programGroup=DiagnosticsAndQCProgramGroup.class)
@DocumentedFeature
public class CalculateFingerprintMetrics
extends CommandLineProgram {
    static final String USAGE_DETAILS = "This tools collects various statistics that pertain to a single fingerprint (<b>not</b> the comparison, or 'fingerprinting' of two distinct samples) and reports the results in a metrics file. <p>The statistics collected are p-values, where the null-hypothesis is that the fingerprint is collected from a non-contaminated, diploid human, whose genotypes are modelled by the probabilities given in the HAPLOTYPE_MAP file.<p>Please see the FingerprintMetrics <a href='http://broadinstitute.github.io/picard/picard-metric-definitions.html#FingerprintMetrics'>definitions</a> for a complete description of the metrics produced by this tool.</p><hr /><p><h3>Example</h3>\n<pre>\" +\njava -jar picard.jar CalculateFingerprintMetrics \\\n      INPUT=sample.bam \\\n      HAPLOTYPE_MAP=fingerprinting_haplotype_database.txt \\\n      OUTPUT=sample.fingerprint_metrics\n </pre>\n";
    static final String USAGE_SUMMARY = "Calculate statistics on fingerprints, checking their viability";
    @Argument(shortName="I", doc="One or more input files (SAM/BAM/CRAM or VCF).")
    public List<String> INPUT;
    @Argument(shortName="O", doc="The output file to write (Metrics).")
    public File OUTPUT;
    @Argument(shortName="H", doc="The file lists a set of SNPs, optionally arranged in high-LD blocks, to be used for fingerprinting. See https://software.broadinstitute.org/gatk/documentation/article?id=9526 for details.")
    public File HAPLOTYPE_MAP;
    @Argument(doc="Specificies which data-type should be used as the basic unit. Fingerprints from readgroups can be \"rolled-up\" to the LIBRARY, SAMPLE, or FILE level before being used. Fingerprints from VCF can be be examined by SAMPLE or FILE.")
    public CrosscheckMetric.DataType CALCULATE_BY = CrosscheckMetric.DataType.READGROUP;
    @Argument(doc="LOD score threshold for considering a genotype to be definitive.")
    public final double GENOTYPE_LOD_THRESHOLD = 3.0;
    @Argument(doc="Number of randomization trials for calculating the DISCRIMINATORY_POWER metric.")
    public final int NUMBER_OF_SAMPLING = 100;
    private static final int RANDOM_SEED = 42;
    private static final ChiSquareTest chiSquareTest = new ChiSquareTest();

    @Override
    protected int doWork() {
        List<Path> inputPaths = IOUtil.getPaths(this.INPUT);
        IOUtil.assertPathsAreReadable(inputPaths);
        IOUtil.assertFileIsReadable(this.HAPLOTYPE_MAP);
        IOUtil.assertFileIsWritable(this.OUTPUT);
        FingerprintChecker checker = new FingerprintChecker(this.HAPLOTYPE_MAP);
        MetricsFile metricsFile = this.getMetricsFile();
        Map<FingerprintIdDetails, Fingerprint> fpMap = checker.fingerprintFiles(inputPaths, 1, 1, TimeUnit.DAYS);
        Map<FingerprintIdDetails, Fingerprint> mergedFpMap = Fingerprint.mergeFingerprintsBy(fpMap, Fingerprint.getFingerprintIdDetailsStringFunction(this.CALCULATE_BY));
        metricsFile.addAllMetrics(mergedFpMap.values().stream().map(this::getFingerprintMetrics).collect(Collectors.toList()));
        metricsFile.write(this.OUTPUT);
        return 0;
    }

    public FingerprintMetrics getFingerprintMetrics(Fingerprint fingerprint) {
        double homsChiSquaredTest;
        double hetsChiSquaredTest;
        double chiSquaredTest;
        MersenneTwister rg = new MersenneTwister(42);
        double[] genotypeCounts = fingerprint.values().stream().map(HaplotypeProbabilities::getPosteriorProbabilities).reduce(MathUtil::sum).orElseGet(() -> new double[]{0.0, 0.0, 0.0});
        double[] expectedRatios = fingerprint.values().stream().map(HaplotypeProbabilities::getPriorProbablities).reduce(MathUtil::sum).orElseGet(() -> new double[]{0.0, 0.0, 0.0});
        double[] homVsHetExpect = new double[]{expectedRatios[HaplotypeProbabilities.Genotype.HOM_ALLELE1.v] + expectedRatios[HaplotypeProbabilities.Genotype.HOM_ALLELE2.v], expectedRatios[HaplotypeProbabilities.Genotype.HET_ALLELE12.v]};
        double[] homVsHetCounts = new double[]{genotypeCounts[HaplotypeProbabilities.Genotype.HOM_ALLELE1.v] + genotypeCounts[HaplotypeProbabilities.Genotype.HOM_ALLELE2.v], genotypeCounts[HaplotypeProbabilities.Genotype.HET_ALLELE12.v]};
        double[] homAllele1VsAllele2Expect = new double[]{expectedRatios[HaplotypeProbabilities.Genotype.HOM_ALLELE1.v], expectedRatios[HaplotypeProbabilities.Genotype.HOM_ALLELE2.v]};
        double[] homAllele1VsAllele2Counts = new double[]{genotypeCounts[HaplotypeProbabilities.Genotype.HOM_ALLELE1.v], genotypeCounts[HaplotypeProbabilities.Genotype.HOM_ALLELE2.v]};
        long[] roundedHom1vsHom2Counts = MathUtil.round(homAllele1VsAllele2Counts);
        long[] roundedHetVsHomCounts = MathUtil.round(homVsHetCounts);
        long[] roundedGenotypeCounts = MathUtil.round(genotypeCounts);
        FingerprintMetrics fingerprintMetrics = new FingerprintMetrics();
        fingerprintMetrics.SAMPLE_ALIAS = fingerprint.getSample();
        fingerprintMetrics.SOURCE = Optional.ofNullable(fingerprint.getSource()).map(p -> p.toUri().toString()).orElse("");
        fingerprintMetrics.INFO = fingerprint.getInfo();
        fingerprintMetrics.HAPLOTYPES = fingerprint.values().size();
        fingerprintMetrics.HAPLOTYPES_WITH_EVIDENCE = fingerprint.values().stream().filter(HaplotypeProbabilities::hasEvidence).count();
        fingerprintMetrics.DEFINITE_GENOTYPES = fingerprint.values().stream().filter(h -> h.getLodMostProbableGenotype() >= 3.0).count();
        fingerprintMetrics.NUM_HOM_ALLELE1 = roundedGenotypeCounts[HaplotypeProbabilities.Genotype.HOM_ALLELE1.v];
        fingerprintMetrics.NUM_HOM_ALLELE2 = roundedGenotypeCounts[HaplotypeProbabilities.Genotype.HOM_ALLELE2.v];
        fingerprintMetrics.NUM_HOM_ANY = roundedHetVsHomCounts[1];
        fingerprintMetrics.NUM_HET = roundedGenotypeCounts[HaplotypeProbabilities.Genotype.HET_ALLELE12.v];
        fingerprintMetrics.EXPECTED_HOM_ALLELE1 = expectedRatios[HaplotypeProbabilities.Genotype.HOM_ALLELE1.v];
        fingerprintMetrics.EXPECTED_HOM_ALLELE2 = expectedRatios[HaplotypeProbabilities.Genotype.HOM_ALLELE2.v];
        fingerprintMetrics.EXPECTED_HET = expectedRatios[HaplotypeProbabilities.Genotype.HET_ALLELE12.v];
        fingerprintMetrics.CHI_SQUARED_PVALUE = chiSquaredTest = chiSquareTest.chiSquareTest(expectedRatios, roundedGenotypeCounts);
        fingerprintMetrics.LOG10_CHI_SQUARED_PVALUE = Math.log10(chiSquaredTest);
        fingerprintMetrics.CROSS_ENTROPY_LOD = MathUtil.klDivergance(genotypeCounts, expectedRatios);
        fingerprintMetrics.HET_CHI_SQUARED_PVALUE = hetsChiSquaredTest = chiSquareTest.chiSquareTest(homVsHetExpect, roundedHetVsHomCounts);
        fingerprintMetrics.LOG10_HET_CHI_SQUARED_PVALUE = Math.log10(hetsChiSquaredTest);
        fingerprintMetrics.HET_CROSS_ENTROPY_LOD = MathUtil.klDivergance(homVsHetCounts, homVsHetExpect);
        fingerprintMetrics.HOM_CHI_SQUARED_PVALUE = homsChiSquaredTest = chiSquareTest.chiSquareTest(homAllele1VsAllele2Expect, roundedHom1vsHom2Counts);
        fingerprintMetrics.LOG10_HOM_CHI_SQUARED_PVALUE = Math.log10(homsChiSquaredTest);
        fingerprintMetrics.HOM_CROSS_ENTROPY_LOD = MathUtil.klDivergance(homAllele1VsAllele2Counts, homAllele1VsAllele2Expect);
        MathUtils.RunningStat randomTrials = new MathUtils.RunningStat();
        IntStream.range(0, 100).forEach(i -> randomTrials.push(FingerprintChecker.calculateMatchResults(fingerprint, CalculateFingerprintMetrics.randomizeFingerprint(fingerprint, rg)).getLOD()));
        fingerprintMetrics.LOD_SELF_CHECK = FingerprintChecker.calculateMatchResults(fingerprint, fingerprint).getLOD();
        fingerprintMetrics.DISCRIMINATORY_POWER = fingerprintMetrics.LOD_SELF_CHECK - randomTrials.mean();
        return fingerprintMetrics;
    }

    private static Fingerprint randomizeFingerprint(Fingerprint fingerprint, RandomGenerator rg) {
        Fingerprint retVal = new Fingerprint(null, null, null);
        RandomDataGenerator rng = new RandomDataGenerator(rg);
        fingerprint.forEach((key, hp) -> {
            HaplotypeProbabilitiesFromGenotypeLikelihoods permutedHaplotypeProbabilities = new HaplotypeProbabilitiesFromGenotypeLikelihoods((HaplotypeBlock)key);
            permutedHaplotypeProbabilities.addToLogLikelihoods(hp.getRepresentativeSnp(), hp.getRepresentativeSnp().getAlleles(), MathUtil.permute(hp.getLogLikelihoods(), rng));
            retVal.add(permutedHaplotypeProbabilities);
        });
        return retVal;
    }
}

