/*
 * Decompiled with CFR 0.152.
 */
package picard.fingerprint;

import htsjdk.samtools.SAMReadGroupRecord;

public class FingerprintIdDetails {
    String platformUnit;
    String runBarcode;
    Integer runLane;
    String molecularBarcode;
    String library;
    String file;
    String sample;
    String group;
    static final String multipleValuesString = "<MULTIPLE_VALUES>";

    public FingerprintIdDetails() {
    }

    public FingerprintIdDetails(String platformUnit, String file) {
        this.getPlatformUnitDetails(platformUnit);
        this.platformUnit = platformUnit;
        this.file = file;
    }

    public FingerprintIdDetails(SAMReadGroupRecord rg, String file) {
        this(rg.getPlatformUnit(), file);
        this.sample = rg.getSample();
        this.library = rg.getLibrary();
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        FingerprintIdDetails that = (FingerprintIdDetails)o;
        if (this.platformUnit != null ? !this.platformUnit.equals(that.platformUnit) : that.platformUnit != null) {
            return false;
        }
        if (this.runBarcode != null ? !this.runBarcode.equals(that.runBarcode) : that.runBarcode != null) {
            return false;
        }
        if (this.runLane != null ? !this.runLane.equals(that.runLane) : that.runLane != null) {
            return false;
        }
        if (this.molecularBarcode != null ? !this.molecularBarcode.equals(that.molecularBarcode) : that.molecularBarcode != null) {
            return false;
        }
        if (this.library != null ? !this.library.equals(that.library) : that.library != null) {
            return false;
        }
        if (this.file != null ? !this.file.equals(that.file) : that.file != null) {
            return false;
        }
        return this.sample != null ? this.sample.equals(that.sample) : that.sample == null;
    }

    public int hashCode() {
        int result = this.platformUnit != null ? this.platformUnit.hashCode() : 0;
        result = 31 * result + (this.runBarcode != null ? this.runBarcode.hashCode() : 0);
        result = 31 * result + (this.runLane != null ? this.runLane.hashCode() : 0);
        result = 31 * result + (this.molecularBarcode != null ? this.molecularBarcode.hashCode() : 0);
        result = 31 * result + (this.library != null ? this.library.hashCode() : 0);
        result = 31 * result + (this.file != null ? this.file.hashCode() : 0);
        result = 31 * result + (this.sample != null ? this.sample.hashCode() : 0);
        return result;
    }

    public FingerprintIdDetails merge(FingerprintIdDetails other) {
        this.platformUnit = FingerprintIdDetails.equalValueOrElse(this.platformUnit, other.platformUnit, multipleValuesString);
        this.runBarcode = FingerprintIdDetails.equalValueOrElse(this.runBarcode, other.runBarcode, multipleValuesString);
        this.runLane = FingerprintIdDetails.equalValueOrElse(this.runLane, other.runLane, Integer.MIN_VALUE);
        this.library = FingerprintIdDetails.equalValueOrElse(this.library, other.library, multipleValuesString);
        this.file = FingerprintIdDetails.equalValueOrElse(this.file, other.file, multipleValuesString);
        this.sample = FingerprintIdDetails.equalValueOrElse(this.sample, other.sample, multipleValuesString);
        this.molecularBarcode = FingerprintIdDetails.equalValueOrElse(this.molecularBarcode, other.molecularBarcode, multipleValuesString);
        return this;
    }

    private static <T> T equalValueOrElse(T lhs, T rhs, T orElse) {
        if (rhs == null) {
            return lhs;
        }
        if (lhs == null) {
            return rhs;
        }
        return lhs.equals(rhs) ? lhs : orElse;
    }

    public String getPlatformUnit() {
        return this.platformUnit;
    }

    public String getSample() {
        return this.sample;
    }

    private void getPlatformUnitDetails(String puString) {
        this.runBarcode = "?";
        this.runLane = -1;
        this.molecularBarcode = "?";
        if (puString == null) {
            return;
        }
        String[] tmp = puString.split("\\.");
        if (tmp.length == 3 || tmp.length == 2) {
            this.runBarcode = tmp[0];
            this.molecularBarcode = tmp.length == 3 ? tmp[2] : "";
            try {
                this.runLane = Integer.parseInt(tmp[1]);
            }
            catch (NumberFormatException numberFormatException) {
                // empty catch block
            }
        }
    }
}

