/*
 * Decompiled with CFR 0.152.
 */
package picard.fingerprint;

import htsjdk.samtools.util.QualityUtil;
import htsjdk.utils.ValidationUtils;
import picard.fingerprint.HaplotypeBlock;
import picard.fingerprint.HaplotypeProbabilities;
import picard.fingerprint.HaplotypeProbabilitiesFromSequence;
import picard.fingerprint.Snp;
import picard.util.MathUtil;

public class HaplotypeProbabilitiesFromContaminatorSequence
extends HaplotypeProbabilitiesFromSequence {
    public double contamination;
    private final double[][] likelihoodMap = new double[][]{{1.0, 1.0, 1.0}, {1.0, 1.0, 1.0}, {1.0, 1.0, 1.0}};
    private boolean valuesNeedUpdating = true;

    public HaplotypeProbabilitiesFromContaminatorSequence(HaplotypeBlock haplotypeBlock, double contamination) {
        super(haplotypeBlock);
        ValidationUtils.validateArg(contamination <= 1.0, () -> "contamination must be <=1, found " + contamination);
        ValidationUtils.validateArg(contamination >= 0.0, () -> "contamination must be >=0, found " + contamination);
        this.contamination = contamination;
    }

    public HaplotypeProbabilitiesFromContaminatorSequence(HaplotypeProbabilitiesFromContaminatorSequence other) {
        super(other);
        this.contamination = other.contamination;
        for (HaplotypeProbabilities.Genotype g : HaplotypeProbabilities.Genotype.values()) {
            System.arraycopy(other.likelihoodMap[g.v], 0, this.likelihoodMap[g.v], 0, NUM_GENOTYPES);
        }
    }

    @Override
    public void addToProbs(Snp snp, byte base, byte qual) {
        boolean altAllele;
        this.assertSnpPartOfHaplotype(snp);
        this.valuesNeedUpdating = true;
        if (base == snp.getAllele1()) {
            ++this.obsAllele1;
            altAllele = false;
        } else if (base == snp.getAllele2()) {
            ++this.obsAllele2;
            altAllele = true;
        } else {
            ++this.obsAlleleOther;
            return;
        }
        double pErr = QualityUtil.getErrorProbabilityFromPhredScore(qual);
        for (HaplotypeProbabilities.Genotype contGeno : HaplotypeProbabilities.Genotype.values()) {
            for (HaplotypeProbabilities.Genotype mainGeno : HaplotypeProbabilities.Genotype.values()) {
                double theta = 0.5 * ((1.0 - this.contamination) * (double)mainGeno.v + this.contamination * (double)contGeno.v);
                double[] dArray = this.likelihoodMap[contGeno.v];
                int n = mainGeno.v;
                dArray[n] = dArray[n] * ((altAllele ? theta : 1.0 - theta) * (1.0 - pErr) + (!altAllele ? theta : 1.0 - theta) * pErr);
            }
        }
    }

    private void updateLikelihoods() {
        if (!this.valuesNeedUpdating) {
            return;
        }
        this.valuesNeedUpdating = false;
        double[] ll = new double[NUM_GENOTYPES];
        for (HaplotypeProbabilities.Genotype contGeno : HaplotypeProbabilities.Genotype.values()) {
            ll[contGeno.v] = Math.log10(Double.MIN_VALUE + MathUtil.sum(MathUtil.multiply(this.getPriorProbablities(), this.likelihoodMap[contGeno.v])));
        }
        this.setLogLikelihoods(ll);
    }

    @Override
    public HaplotypeProbabilitiesFromContaminatorSequence deepCopy() {
        return new HaplotypeProbabilitiesFromContaminatorSequence(this);
    }

    @Override
    public HaplotypeProbabilitiesFromContaminatorSequence merge(HaplotypeProbabilities other) {
        super.merge(other);
        if (!this.getHaplotype().equals(other.getHaplotype())) {
            throw new IllegalArgumentException("Mismatched haplotypes in call to HaplotypeProbabilities.merge(): " + this.getHaplotype() + ", " + other.getHaplotype());
        }
        if (!(other instanceof HaplotypeProbabilitiesFromContaminatorSequence)) {
            throw new IllegalArgumentException("Can only merge HaplotypeProbabilities of same class.");
        }
        HaplotypeProbabilitiesFromContaminatorSequence o = (HaplotypeProbabilitiesFromContaminatorSequence)other;
        if (o.contamination != this.contamination) {
            throw new IllegalArgumentException("Can only merge HaplotypeProbabilitiesFromContaminatorSequence with the same contamination value.");
        }
        for (HaplotypeProbabilities.Genotype contGeno : HaplotypeProbabilities.Genotype.values()) {
            this.likelihoodMap[contGeno.v] = MathUtil.multiply(this.likelihoodMap[contGeno.v], o.likelihoodMap[contGeno.v]);
        }
        this.valuesNeedUpdating = true;
        return this;
    }

    @Override
    public double[] getLikelihoods() {
        this.updateLikelihoods();
        return super.getLikelihoods();
    }

    @Override
    public double[] getLogLikelihoods() {
        this.updateLikelihoods();
        return super.getLogLikelihoods();
    }
}

