/*
 * Decompiled with CFR 0.152.
 */
package picard.illumina;

import htsjdk.samtools.util.IOUtil;
import htsjdk.samtools.util.Log;
import htsjdk.samtools.util.ProgressLogger;
import java.io.File;
import java.time.Duration;
import java.util.Arrays;
import java.util.Comparator;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.TimeUnit;
import java.util.regex.Pattern;
import picard.PicardException;
import picard.illumina.UnsortedBasecallsConverter;
import picard.illumina.parser.ClusterData;
import picard.illumina.parser.IlluminaDataProviderFactory;
import picard.illumina.parser.IlluminaDataType;
import picard.illumina.parser.ReadStructure;
import picard.illumina.parser.readers.BclQualityEvaluationStrategy;
import picard.util.ThreadPoolExecutorUtil;
import picard.util.ThreadPoolExecutorWithExceptions;

public abstract class BasecallsConverter<CLUSTER_OUTPUT_RECORD> {
    public static final Set<IlluminaDataType> DATA_TYPES_WITH_BARCODE = new HashSet<IlluminaDataType>(Arrays.asList(IlluminaDataType.BaseCalls, IlluminaDataType.QualityScores, IlluminaDataType.Position, IlluminaDataType.PF, IlluminaDataType.Barcodes));
    public static final Set<IlluminaDataType> DATA_TYPES_WITHOUT_BARCODE = new HashSet<IlluminaDataType>(Arrays.asList(IlluminaDataType.BaseCalls, IlluminaDataType.QualityScores, IlluminaDataType.Position, IlluminaDataType.PF));
    protected static final Log log = Log.getInstance(UnsortedBasecallsConverter.class);
    protected final IlluminaDataProviderFactory factory;
    protected final boolean demultiplex;
    protected final boolean ignoreUnexpectedBarcodes;
    protected final Map<String, ? extends ConvertedClusterDataWriter<CLUSTER_OUTPUT_RECORD>> barcodeRecordWriterMap;
    protected final boolean includeNonPfReads;
    protected final int numThreads;
    protected final ProgressLogger readProgressLogger = new ProgressLogger(log, 1000000, "Read");
    protected final ProgressLogger writeProgressLogger = new ProgressLogger(log, 1000000, "Write");
    protected final Map<Integer, List<? extends Runnable>> completedWork = new HashMap<Integer, List<? extends Runnable>>();
    protected final ThreadPoolExecutorWithExceptions tileWriteExecutor;
    protected final ThreadPoolExecutorWithExceptions tileReadExecutor;
    protected final ThreadPoolExecutorWithExceptions completedWorkExecutor = new ThreadPoolExecutorWithExceptions(1);
    protected ClusterDataConverter<CLUSTER_OUTPUT_RECORD> converter = null;
    protected List<Integer> tiles;
    protected boolean tileProcessingComplete = false;
    public static final Comparator<Integer> TILE_NUMBER_COMPARATOR = (integer1, integer2) -> {
        String s1 = integer1.toString();
        String s2 = integer2.toString();
        if (s1.length() < s2.length()) {
            if (s2.startsWith(s1)) {
                return 1;
            }
        } else if (s2.length() < s1.length() && s1.startsWith(s2)) {
            return -1;
        }
        return s1.compareTo(s2);
    };

    public BasecallsConverter(File basecallsDir, File barcodesDir, int lane, ReadStructure readStructure, Map<String, ? extends ConvertedClusterDataWriter<CLUSTER_OUTPUT_RECORD>> barcodeRecordWriterMap, boolean demultiplex, int numThreads, Integer firstTile, Integer tileLimit, BclQualityEvaluationStrategy bclQualityEvaluationStrategy, boolean ignoreUnexpectedBarcodes, boolean applyEamssFiltering, boolean includeNonPfReads, int numWriteThreads) {
        this.barcodeRecordWriterMap = barcodeRecordWriterMap;
        this.ignoreUnexpectedBarcodes = ignoreUnexpectedBarcodes;
        this.demultiplex = demultiplex;
        this.numThreads = numThreads;
        this.factory = new IlluminaDataProviderFactory(basecallsDir, barcodesDir, lane, readStructure, bclQualityEvaluationStrategy, BasecallsConverter.getDataTypesFromReadStructure(readStructure, demultiplex));
        this.factory.setApplyEamssFiltering(applyEamssFiltering);
        this.includeNonPfReads = includeNonPfReads;
        this.tiles = this.factory.getAvailableTiles();
        this.tiles.sort(TILE_NUMBER_COMPARATOR);
        this.setTileLimits(firstTile, tileLimit);
        this.tileWriteExecutor = new ThreadPoolExecutorWithExceptions(numWriteThreads);
        this.tileWriteExecutor.setKeepAliveTime(500L, TimeUnit.MILLISECONDS);
        this.tileReadExecutor = new ThreadPoolExecutorWithExceptions(numThreads);
        CompletedWorkChecker workChecker = new CompletedWorkChecker();
        this.completedWorkExecutor.submit(workChecker);
        this.completedWorkExecutor.shutdown();
    }

    public abstract void processTilesAndWritePerSampleOutputs(Set<String> var1);

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void awaitTileProcessingCompletion() {
        this.tileReadExecutor.shutdown();
        ThreadPoolExecutorUtil.awaitThreadPoolTermination("Reading executor", this.tileReadExecutor, Duration.ofMinutes(5L));
        this.tileProcessingComplete = true;
        try {
            if (this.tileReadExecutor.hasError()) {
                this.interruptAndShutdownExecutors(this.tileReadExecutor, this.completedWorkExecutor, this.tileWriteExecutor);
            }
            Map<Integer, List<? extends Runnable>> map = this.completedWork;
            synchronized (map) {
                log.debug("Final notification of work complete.");
                this.completedWork.notifyAll();
            }
            ThreadPoolExecutorUtil.awaitThreadPoolTermination("Tile completion executor", this.completedWorkExecutor, Duration.ofMinutes(5L));
            if (this.completedWorkExecutor.hasError()) {
                this.interruptAndShutdownExecutors(this.tileReadExecutor, this.completedWorkExecutor, this.tileWriteExecutor);
            }
        }
        finally {
            this.barcodeRecordWriterMap.values().forEach(ConvertedClusterDataWriter::close);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void notifyWorkComplete(int tileNum, List<? extends Runnable> pumpList) {
        Map<Integer, List<? extends Runnable>> map = this.completedWork;
        synchronized (map) {
            log.debug("Notifying completed work. Tile: " + tileNum);
            this.completedWork.put(tileNum, pumpList);
            this.completedWork.notifyAll();
        }
    }

    public static File[] getTiledFiles(File baseDirectory, Pattern pattern) {
        return IOUtil.getFilesMatchingRegexp(baseDirectory, pattern);
    }

    protected static Set<IlluminaDataType> getDataTypesFromReadStructure(ReadStructure readStructure, boolean demultiplex) {
        if (!readStructure.hasSampleBarcode() || !demultiplex) {
            return DATA_TYPES_WITHOUT_BARCODE;
        }
        return DATA_TYPES_WITH_BARCODE;
    }

    protected IlluminaDataProviderFactory getFactory() {
        return this.factory;
    }

    protected void setConverter(ClusterDataConverter<CLUSTER_OUTPUT_RECORD> converter) {
        this.converter = converter;
    }

    protected void setTileLimits(Integer firstTile, Integer tileLimit) {
        if (firstTile != null) {
            for (int i = 0; i < this.tiles.size(); ++i) {
                if (this.tiles.get(i).intValue() != firstTile.intValue()) continue;
                this.tiles = this.tiles.subList(i, this.tiles.size());
                break;
            }
            if (this.tiles.get(0).intValue() != firstTile.intValue()) {
                throw new PicardException("firstTile=" + firstTile + ", but that tile was not found.");
            }
        }
        if (tileLimit != null && this.tiles.size() > tileLimit) {
            this.tiles = this.tiles.subList(0, tileLimit);
        }
    }

    protected void interruptAndShutdownExecutors(ThreadPoolExecutorWithExceptions ... executors) {
        int tasksRunning = Arrays.stream(executors).mapToInt(test -> test.shutdownNow().size()).sum();
        throw new PicardException("Exceptions in tile processing. There were " + tasksRunning + " tasks were still running or queued and have been cancelled.");
    }

    protected class CompletedWorkChecker
    implements Runnable {
        private int currentTileIndex = 0;

        protected CompletedWorkChecker() {
        }

        @Override
        public void run() {
            try {
                this.checkCompletedWork();
            }
            catch (InterruptedException e) {
                e.printStackTrace();
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        private void checkCompletedWork() throws InterruptedException {
            Map<Integer, List<? extends Runnable>> map = BasecallsConverter.this.completedWork;
            synchronized (map) {
                while (this.currentTileIndex < BasecallsConverter.this.tiles.size()) {
                    Integer currentTile;
                    if (!BasecallsConverter.this.tileProcessingComplete) {
                        log.debug("Waiting for completed work.");
                        BasecallsConverter.this.completedWork.wait();
                    }
                    if (!BasecallsConverter.this.completedWork.containsKey(currentTile = BasecallsConverter.this.tiles.get(this.currentTileIndex)) || BasecallsConverter.this.tileWriteExecutor.getQueue().size() != 0 || BasecallsConverter.this.tileWriteExecutor.getActiveCount() != 0 || BasecallsConverter.this.tileWriteExecutor.getTaskCount() != BasecallsConverter.this.tileWriteExecutor.getCompletedTaskCount()) continue;
                    Thread.sleep(100L);
                    log.debug("Writing out tile. Tile: " + currentTile);
                    BasecallsConverter.this.completedWork.get(currentTile).forEach(BasecallsConverter.this.tileWriteExecutor::submit);
                    ++this.currentTileIndex;
                }
                BasecallsConverter.this.tileWriteExecutor.shutdown();
                ThreadPoolExecutorUtil.awaitThreadPoolTermination("Tile completion executor", BasecallsConverter.this.tileWriteExecutor, Duration.ofMinutes(5L));
                if (BasecallsConverter.this.tileWriteExecutor.hasError()) {
                    BasecallsConverter.this.interruptAndShutdownExecutors(BasecallsConverter.this.tileReadExecutor, BasecallsConverter.this.completedWorkExecutor, BasecallsConverter.this.tileWriteExecutor);
                }
            }
        }
    }

    protected static interface ConvertedClusterDataWriter<OUTPUT_RECORD> {
        public void write(OUTPUT_RECORD var1);

        public void close();
    }

    protected static interface ClusterDataConverter<OUTPUT_RECORD> {
        public OUTPUT_RECORD convertClusterToOutputRecord(ClusterData var1);
    }
}

