/*
 * Decompiled with CFR 0.152.
 */
package picard.illumina;

import htsjdk.samtools.Defaults;
import htsjdk.samtools.SAMUtils;
import htsjdk.samtools.fastq.FastqWriterFactory;
import htsjdk.samtools.util.AbstractAsyncWriter;
import htsjdk.samtools.util.BinaryCodec;
import htsjdk.samtools.util.BlockCompressedOutputStream;
import htsjdk.samtools.util.CollectionUtil;
import htsjdk.samtools.util.IOUtil;
import htsjdk.samtools.util.Log;
import htsjdk.samtools.util.Md5CalculatingOutputStream;
import htsjdk.samtools.util.RuntimeEOFException;
import htsjdk.samtools.util.RuntimeIOException;
import htsjdk.samtools.util.SortingCollection;
import htsjdk.samtools.util.StringUtil;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.nio.charset.StandardCharsets;
import java.nio.file.Files;
import java.nio.file.OpenOption;
import java.nio.file.Path;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Comparator;
import java.util.HashMap;
import java.util.HashSet;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.broadinstitute.barclay.argparser.Argument;
import org.broadinstitute.barclay.argparser.CommandLineProgramProperties;
import org.broadinstitute.barclay.help.DocumentedFeature;
import picard.PicardException;
import picard.cmdline.CommandLineProgram;
import picard.cmdline.programgroups.BaseCallingProgramGroup;
import picard.fastq.Casava18ReadNameEncoder;
import picard.fastq.IlluminaReadNameEncoder;
import picard.fastq.ReadNameEncoder;
import picard.illumina.BasecallsConverter;
import picard.illumina.BasecallsConverterBuilder;
import picard.illumina.parser.ClusterData;
import picard.illumina.parser.ReadData;
import picard.illumina.parser.ReadStructure;
import picard.illumina.parser.ReadType;
import picard.illumina.parser.readers.BclQualityEvaluationStrategy;
import picard.util.IlluminaUtil;
import picard.util.TabbedTextFileWithHeaderParser;

@CommandLineProgramProperties(summary="Generate FASTQ file(s) from Illumina basecall read data.  <p>This tool generates FASTQ files from data in an Illumina BaseCalls output directory.  Separate FASTQ files are created for each template, barcode, and index (molecular barcode) read.  Briefly, the template reads are the target sequence of your experiment, the barcode sequence reads facilitate sample demultiplexing, and the index reads help mitigate instrument phasing errors.  For additional information on the read types, please see the following reference <a href'=http://www.ncbi.nlm.nih.gov/pmc/articles/PMC3245947/'>here</a>.</p><p>In the absence of sample pooling (multiplexing) and/or barcodes, then an OUTPUT_PREFIX (file directory) must be provided as the sample identifier.  For multiplexed samples, a MULTIPLEX_PARAMS file must be specified.  The MULTIPLEX_PARAMS file contains the list of sample barcodes used to sort template, barcode, and index reads.  It is essentially the same as the BARCODE_FILE used in the<a href='http://broadinstitute.github.io/picard/command-line-overview.html#ExtractIlluminaBarcodes'>ExtractIlluminaBarcodes</a> tool.</p>     <p>Files from this tool use the following naming format: {prefix}.{type}_{number}.fastq with the {prefix} indicating the sample barcode, the {type} indicating the types of reads e.g. index, barcode, or blank (if it contains a template read).  The {number} indicates the read number, either first (1) or second (2) for paired-end sequencing. </p> <h4>Usage examples:</h4><pre>Example 1: Sample(s) with either no barcode or barcoded without multiplexing <br />java -jar picard.jar IlluminaBasecallsToFastq \\<br />      READ_STRUCTURE=25T8B25T \\<br />      BASECALLS_DIR=basecallDirectory \\<br />      LANE=001 \\<br />      OUTPUT_PREFIX=noBarcode.1 \\<br />      RUN_BARCODE=run15 \\<br />      FLOWCELL_BARCODE=abcdeACXX <br /><br />Example 2: Multiplexed samples <br />java -jar picard.jar IlluminaBasecallsToFastq \\<br />      READ_STRUCTURE=25T8B25T \\<br />      BASECALLS_DIR=basecallDirectory \\<br />      LANE=001 \\<br />      MULTIPLEX_PARAMS=demultiplexed_output.txt \\<br />      RUN_BARCODE=run15 \\<br />      FLOWCELL_BARCODE=abcdeACXX <br /></pre><p>The FLOWCELL_BARCODE is required if emitting Casava 1.8-style read name headers.</p><hr />", oneLineSummary="Generate FASTQ file(s) from Illumina basecall read data.  ", programGroup=BaseCallingProgramGroup.class)
@DocumentedFeature
public class IlluminaBasecallsToFastq
extends CommandLineProgram {
    static final String USAGE_SUMMARY = "Generate FASTQ file(s) from Illumina basecall read data.  ";
    static final String USAGE_DETAILS = "<p>This tool generates FASTQ files from data in an Illumina BaseCalls output directory.  Separate FASTQ files are created for each template, barcode, and index (molecular barcode) read.  Briefly, the template reads are the target sequence of your experiment, the barcode sequence reads facilitate sample demultiplexing, and the index reads help mitigate instrument phasing errors.  For additional information on the read types, please see the following reference <a href'=http://www.ncbi.nlm.nih.gov/pmc/articles/PMC3245947/'>here</a>.</p><p>In the absence of sample pooling (multiplexing) and/or barcodes, then an OUTPUT_PREFIX (file directory) must be provided as the sample identifier.  For multiplexed samples, a MULTIPLEX_PARAMS file must be specified.  The MULTIPLEX_PARAMS file contains the list of sample barcodes used to sort template, barcode, and index reads.  It is essentially the same as the BARCODE_FILE used in the<a href='http://broadinstitute.github.io/picard/command-line-overview.html#ExtractIlluminaBarcodes'>ExtractIlluminaBarcodes</a> tool.</p>     <p>Files from this tool use the following naming format: {prefix}.{type}_{number}.fastq with the {prefix} indicating the sample barcode, the {type} indicating the types of reads e.g. index, barcode, or blank (if it contains a template read).  The {number} indicates the read number, either first (1) or second (2) for paired-end sequencing. </p> <h4>Usage examples:</h4><pre>Example 1: Sample(s) with either no barcode or barcoded without multiplexing <br />java -jar picard.jar IlluminaBasecallsToFastq \\<br />      READ_STRUCTURE=25T8B25T \\<br />      BASECALLS_DIR=basecallDirectory \\<br />      LANE=001 \\<br />      OUTPUT_PREFIX=noBarcode.1 \\<br />      RUN_BARCODE=run15 \\<br />      FLOWCELL_BARCODE=abcdeACXX <br /><br />Example 2: Multiplexed samples <br />java -jar picard.jar IlluminaBasecallsToFastq \\<br />      READ_STRUCTURE=25T8B25T \\<br />      BASECALLS_DIR=basecallDirectory \\<br />      LANE=001 \\<br />      MULTIPLEX_PARAMS=demultiplexed_output.txt \\<br />      RUN_BARCODE=run15 \\<br />      FLOWCELL_BARCODE=abcdeACXX <br /></pre><p>The FLOWCELL_BARCODE is required if emitting Casava 1.8-style read name headers.</p><hr />";
    @Argument(doc="The basecalls directory. ", shortName="B")
    public File BASECALLS_DIR;
    @Argument(doc="The barcodes directory with _barcode.txt files (generated by ExtractIlluminaBarcodes). If not set, use BASECALLS_DIR. ", shortName="BCD", optional=true)
    public File BARCODES_DIR;
    @Argument(doc="Lane number. ", shortName="L")
    public Integer LANE;
    @Argument(doc="The prefix for output FASTQs.  Extensions as described above are appended.  Use this option for a non-barcoded run, or for a barcoded run in which it is not desired to demultiplex reads into separate files by barcode.", shortName="O", mutex={"MULTIPLEX_PARAMS"})
    public File OUTPUT_PREFIX;
    @Argument(doc="The barcode of the run.  Prefixed to read names.")
    public String RUN_BARCODE;
    @Argument(doc="The name of the machine on which the run was sequenced; required if emitting Casava1.8-style read name headers", optional=true)
    public String MACHINE_NAME;
    @Argument(doc="The barcode of the flowcell that was sequenced; required if emitting Casava1.8-style read name headers", optional=true)
    public String FLOWCELL_BARCODE;
    @Argument(doc="A description of the logical structure of clusters in an Illumina Run, i.e. a description of the structure IlluminaBasecallsToSam assumes the  data to be in. It should consist of integer/character pairs describing the number of cycles and the type of those cycles (B for Sample Barcode, M for molecular barcode, T for Template, and S for skip).  E.g. If the input data consists of 80 base clusters and we provide a read structure of \"28T8M8B8S28T\" then the sequence may be split up into four reads:\n* read one with 28 cycles (bases) of template\n* read two with 8 cycles (bases) of molecular barcode (ex. unique molecular barcode)\n* read three with 8 cycles (bases) of sample barcode\n* 8 cycles (bases) skipped.\n* read four with 28 cycles (bases) of template\nThe skipped cycles would NOT be included in an output SAM/BAM file or in read groups therein.", shortName="RS")
    public String READ_STRUCTURE;
    @Argument(doc="Tab-separated file for creating all output FASTQs demultiplexed by barcode for a lane with single IlluminaBasecallsToFastq invocation.  The columns are OUTPUT_PREFIX, and BARCODE_1, BARCODE_2 ... BARCODE_X where X = number of barcodes per cluster (optional).  Row with BARCODE_1 set to 'N' is used to specify an output_prefix for no barcode match.", mutex={"OUTPUT_PREFIX"})
    public File MULTIPLEX_PARAMS;
    @Deprecated
    @Argument(doc="Deprecated (No longer used). Which adapters to look for in the read.", optional=true)
    public List<IlluminaUtil.IlluminaAdapterPair> ADAPTERS_TO_CHECK = null;
    @Argument(doc="The number of threads to run in parallel. If NUM_PROCESSORS = 0, number of cores is automatically set to the number of cores available on the machine. If NUM_PROCESSORS < 0, then the number of cores used will be the number available on the machine less NUM_PROCESSORS.")
    public Integer NUM_PROCESSORS = 0;
    @Argument(doc="If set, this is the first tile to be processed (used for debugging).  Note that tiles are not processed in numerical order.", optional=true)
    public Integer FIRST_TILE;
    @Argument(doc="If set, process no more than this many tiles (used for debugging).", optional=true)
    public Integer TILE_LIMIT;
    @Argument(doc="Apply EAMSS filtering to identify inappropriately quality scored bases towards the ends of reads and convert their quality scores to Q2.")
    public boolean APPLY_EAMSS_FILTER = true;
    @Argument(doc="If true, call System.gc() periodically.  This is useful in cases in which the -Xmx value passed is larger than the available memory.")
    public Boolean FORCE_GC = true;
    @Argument(doc="If true, the output records are sorted by read name. Otherwise they are output in the same order that the data was produced on the sequencer (ordered by tile and position).")
    public Boolean SORT = true;
    @Deprecated
    @Argument(doc="Configure SortingCollections to store this many records before spilling to disk. For an indexed run, each SortingCollection gets this value/number of indices. Deprecated: use `MAX_RECORDS_IN_RAM`")
    public int MAX_READS_IN_RAM_PER_TILE = -1;
    @Argument(doc="The minimum quality (after transforming 0s to 1s) expected from reads.  If qualities are lower than this value, an error is thrown.The default of 2 is what the Illumina's spec describes as the minimum, but in practice the value has been observed lower.")
    public int MINIMUM_QUALITY = 2;
    @Argument(doc="Whether to include non-PF reads", shortName="NONPF", optional=true)
    public boolean INCLUDE_NON_PF_READS = true;
    @Argument(doc="Whether to ignore reads whose barcodes are not found in MULTIPLEX_PARAMS.  Useful when outputting FASTQs for only a subset of the barcodes in a lane.", shortName="INGORE_UNEXPECTED")
    public boolean IGNORE_UNEXPECTED_BARCODES = false;
    @Argument(doc="The read name header formatting to emit.  Casava1.8 formatting has additional information beyond Illumina, including: the passing-filter flag value for the read, the flowcell name, and the sequencer name.")
    public ReadNameFormat READ_NAME_FORMAT = ReadNameFormat.CASAVA_1_8;
    @Argument(shortName="GZIP", doc="Compress output FASTQ files using gzip and append a .gz extension to the file names.")
    public boolean COMPRESS_OUTPUTS = false;
    private final Map<String, AsyncClusterWriter> sampleBarcodeClusterWriterMap = new HashMap<String, AsyncClusterWriter>(1, 0.5f);
    final BclQualityEvaluationStrategy bclQualityEvaluationStrategy = new BclQualityEvaluationStrategy(this.MINIMUM_QUALITY);
    private ReadStructure readStructure;
    private BasecallsConverter<?> basecallsConverter;
    private static final Log log = Log.getInstance(IlluminaBasecallsToFastq.class);
    private final FastqWriterFactory fastqWriterFactory = new FastqWriterFactory();
    private ReadNameEncoder readNameEncoder;

    @Override
    protected int doWork() {
        this.initialize();
        Set<String> barcodes = this.sampleBarcodeClusterWriterMap.keySet();
        this.basecallsConverter.processTilesAndWritePerSampleOutputs(barcodes);
        return 0;
    }

    @Override
    protected String[] customCommandLineValidation() {
        LinkedList<String> errors = new LinkedList<String>();
        if (this.MAX_READS_IN_RAM_PER_TILE != -1) {
            log.warn("Setting deprecated parameter `MAX_READS_IN_RAM_PER_TILE` use ` MAX_RECORDS_IN_RAM` instead");
            this.MAX_RECORDS_IN_RAM = this.MAX_READS_IN_RAM_PER_TILE;
        }
        if (this.READ_NAME_FORMAT == ReadNameFormat.CASAVA_1_8 && this.MACHINE_NAME == null) {
            errors.add("MACHINE_NAME is required when using Casava1.8-style read name headers.");
        }
        if (this.READ_NAME_FORMAT == ReadNameFormat.CASAVA_1_8 && this.FLOWCELL_BARCODE == null) {
            errors.add("FLOWCELL_BARCODE is required when using Casava1.8-style read name headers.");
        }
        if (this.ADAPTERS_TO_CHECK != null) {
            log.warn("ADAPTERS_TO_CHECK is not used");
        }
        if (errors.isEmpty()) {
            return null;
        }
        return errors.toArray(new String[errors.size()]);
    }

    private void initialize() {
        boolean demultiplex;
        this.fastqWriterFactory.setCreateMd5(this.CREATE_MD5_FILE);
        switch (this.READ_NAME_FORMAT) {
            case CASAVA_1_8: {
                this.readNameEncoder = new Casava18ReadNameEncoder(this.MACHINE_NAME, this.RUN_BARCODE, this.FLOWCELL_BARCODE);
                break;
            }
            case ILLUMINA: {
                this.readNameEncoder = new IlluminaReadNameEncoder(this.RUN_BARCODE);
            }
        }
        this.readStructure = new ReadStructure(this.READ_STRUCTURE);
        if (this.MULTIPLEX_PARAMS != null) {
            IOUtil.assertFileIsReadable(this.MULTIPLEX_PARAMS);
        }
        if (this.OUTPUT_PREFIX != null) {
            this.sampleBarcodeClusterWriterMap.put(null, this.buildWriter(this.OUTPUT_PREFIX));
            demultiplex = false;
        } else {
            this.populateWritersFromMultiplexParams();
            demultiplex = true;
        }
        BasecallsConverterBuilder<ClusterData> converterBuilder = new BasecallsConverterBuilder(this.BASECALLS_DIR, this.LANE, this.readStructure, this.sampleBarcodeClusterWriterMap).barcodesDir(this.BARCODES_DIR).withDemultiplex(demultiplex).numProcessors(this.NUM_PROCESSORS).firstTile(this.FIRST_TILE).tileLimit(this.TILE_LIMIT).withMaxRecordsInRam(this.MAX_RECORDS_IN_RAM).withApplyEamssFiltering(this.APPLY_EAMSS_FILTER).withIncludeNonPfReads(this.INCLUDE_NON_PF_READS).withIgnoreUnexpectedBarcodes(this.IGNORE_UNEXPECTED_BARCODES).withBclQualityEvaluationStrategy(this.bclQualityEvaluationStrategy);
        if (this.SORT.booleanValue()) {
            ClusterDataQueryNameComparator queryNameComparator = new ClusterDataQueryNameComparator(this.readNameEncoder);
            converterBuilder = converterBuilder.withSorting(queryNameComparator, new ClusterDataCodec(), ClusterData.class, this.TMP_DIR);
        }
        BasecallsConverter<ClusterData> converter = converterBuilder.build();
        converter.setConverter(new NoOpClusterConverter());
        this.basecallsConverter = converter;
        log.info("READ STRUCTURE IS " + this.readStructure.toString());
    }

    private void assertExpectedColumns(Set<String> actualCols, Set<String> expectedCols) {
        HashSet<String> missingColumns = new HashSet<String>(expectedCols);
        missingColumns.removeAll(actualCols);
        if (!missingColumns.isEmpty()) {
            throw new PicardException(String.format("MULTIPLEX_PARAMS file %s is missing the following columns: %s.", this.MULTIPLEX_PARAMS.getAbsolutePath(), StringUtil.join(", ", missingColumns)));
        }
    }

    private void populateWritersFromMultiplexParams() {
        TabbedTextFileWithHeaderParser libraryParamsParser = new TabbedTextFileWithHeaderParser(this.MULTIPLEX_PARAMS);
        Set<String> expectedColumnLabels = CollectionUtil.makeSet("OUTPUT_PREFIX");
        ArrayList<String> sampleBarcodeColumnLabels = new ArrayList<String>();
        for (int i = 1; i <= this.readStructure.sampleBarcodes.length(); ++i) {
            sampleBarcodeColumnLabels.add("BARCODE_" + i);
        }
        expectedColumnLabels.addAll(sampleBarcodeColumnLabels);
        this.assertExpectedColumns(libraryParamsParser.columnLabels(), expectedColumnLabels);
        List rows = libraryParamsParser.iterator().toList();
        HashSet<String> seenBarcodes = new HashSet<String>();
        for (TabbedTextFileWithHeaderParser.Row row : rows) {
            String key;
            ArrayList<String> sampleBarcodeValues = null;
            if (!sampleBarcodeColumnLabels.isEmpty()) {
                sampleBarcodeValues = new ArrayList<String>();
                for (String sampleBarcodeLabel : sampleBarcodeColumnLabels) {
                    sampleBarcodeValues.add(row.getField(sampleBarcodeLabel));
                }
            }
            String string = key = sampleBarcodeValues == null || sampleBarcodeValues.contains("N") ? null : StringUtil.join("", sampleBarcodeValues);
            if (seenBarcodes.contains(key)) {
                throw new PicardException("Row for barcode " + key + " appears more than once in MULTIPLEX_PARAMS file " + this.MULTIPLEX_PARAMS);
            }
            seenBarcodes.add(key);
            this.sampleBarcodeClusterWriterMap.put(key, this.buildWriter(new File(row.getField("OUTPUT_PREFIX"))));
        }
        if (seenBarcodes.isEmpty()) {
            throw new PicardException("MULTIPLEX_PARAMS file " + this.MULTIPLEX_PARAMS + " does have any data rows.");
        }
        libraryParamsParser.close();
    }

    private AsyncClusterWriter buildWriter(File outputPrefix) {
        int i;
        File outputDir = outputPrefix.getAbsoluteFile().getParentFile();
        IOUtil.assertDirectoryIsWritable(outputDir);
        String prefixString = outputPrefix.getName();
        String suffixString = this.COMPRESS_OUTPUTS ? "fastq.gz" : "fastq";
        File[] templateFiles = new File[this.readStructure.templates.length()];
        File[] sampleBarcodeFiles = new File[this.readStructure.sampleBarcodes.length()];
        File[] molecularBarcodeFiles = new File[this.readStructure.molecularBarcode.length()];
        for (i = 0; i < templateFiles.length; ++i) {
            templateFiles[i] = new File(outputDir, String.format("%s.%d.%s", prefixString, i + 1, suffixString));
        }
        for (i = 0; i < sampleBarcodeFiles.length; ++i) {
            sampleBarcodeFiles[i] = new File(outputDir, String.format("%s.barcode_%d.%s", prefixString, i + 1, suffixString));
        }
        for (i = 0; i < molecularBarcodeFiles.length; ++i) {
            molecularBarcodeFiles[i] = new File(outputDir, String.format("%s.index_%d.%s", prefixString, i + 1, suffixString));
        }
        return new AsyncClusterWriter(new ClusterToFastqWriter(templateFiles, sampleBarcodeFiles, molecularBarcodeFiles), 1024);
    }

    private static class ClusterDataQueryNameComparator
    implements Comparator<ClusterData> {
        private final ReadNameEncoder readNameEncoder;

        public ClusterDataQueryNameComparator(ReadNameEncoder readNameEncoder) {
            this.readNameEncoder = readNameEncoder;
        }

        @Override
        public int compare(ClusterData o1, ClusterData o2) {
            return this.readNameEncoder.generateShortName(o1).compareTo(this.readNameEncoder.generateShortName(o2));
        }
    }

    private static class ClusterDataCodec
    implements SortingCollection.Codec<ClusterData> {
        private final BinaryCodec binaryCodec = new BinaryCodec();

        private ClusterDataCodec() {
        }

        @Override
        public void setOutputStream(OutputStream os) {
            this.binaryCodec.setOutputStream(os);
        }

        @Override
        public void setInputStream(InputStream is) {
            this.binaryCodec.setInputStream(is);
        }

        @Override
        public void encode(ClusterData clusterData) {
            this.binaryCodec.writeInt(clusterData.getNumReads());
            this.binaryCodec.writeInt(clusterData.getLane());
            this.binaryCodec.writeInt(clusterData.getTile());
            this.binaryCodec.writeInt(clusterData.getX());
            this.binaryCodec.writeInt(clusterData.getY());
            this.binaryCodec.writeBoolean(clusterData.isPf());
            if (clusterData.getMatchedBarcode() != null) {
                this.binaryCodec.writeString(clusterData.getMatchedBarcode(), true, true);
            } else {
                this.binaryCodec.writeString("", true, true);
            }
            for (int i = 0; i < clusterData.getNumReads(); ++i) {
                ReadData read = clusterData.getRead(i);
                byte[] bases = read.getBases();
                byte[] quals = read.getQualities();
                this.binaryCodec.writeInt(bases.length);
                this.binaryCodec.writeString(read.getReadType().name(), false, false);
                for (int j = 0; j < bases.length; ++j) {
                    this.binaryCodec.writeByte(bases[j]);
                    this.binaryCodec.writeByte(quals[j]);
                }
            }
        }

        @Override
        public ClusterData decode() {
            int numReads;
            try {
                numReads = this.binaryCodec.readInt();
            }
            catch (RuntimeEOFException e) {
                return null;
            }
            ReadData[] readData = new ReadData[numReads];
            ClusterData clusterData = new ClusterData(readData);
            clusterData.setLane(this.binaryCodec.readInt());
            clusterData.setTile(this.binaryCodec.readInt());
            clusterData.setX(this.binaryCodec.readInt());
            clusterData.setY(this.binaryCodec.readInt());
            clusterData.setPf(this.binaryCodec.readBoolean());
            String matchedBarcode = this.binaryCodec.readLengthAndString(true);
            if (matchedBarcode.length() == 0) {
                clusterData.setMatchedBarcode(null);
            } else {
                clusterData.setMatchedBarcode(matchedBarcode);
            }
            for (int i = 0; i < numReads; ++i) {
                ReadData read = new ReadData();
                int numBases = this.binaryCodec.readInt();
                read.setReadType(ReadType.valueOf(this.binaryCodec.readString(1)));
                byte[] bases = new byte[numBases];
                byte[] quals = new byte[numBases];
                for (int j = 0; j < numBases; ++j) {
                    bases[j] = this.binaryCodec.readByte();
                    quals[j] = this.binaryCodec.readByte();
                }
                read.setBases(bases);
                read.setQualities(quals);
                readData[i] = read;
            }
            return clusterData;
        }

        @Override
        public SortingCollection.Codec<ClusterData> clone() {
            return new ClusterDataCodec();
        }
    }

    private final class ClusterToFastqWriter
    implements BasecallsConverter.ConvertedClusterDataWriter<ClusterData> {
        public static final char NEW_LINE = '\n';
        public static final char AT_SYMBOL = '@';
        public static final char PLUS = '+';
        private final OutputStream[] templateOut;
        private final OutputStream[] sampleBarcodeOut;
        private final OutputStream[] molecularBarcodeOut;
        private final boolean appendTemplateNumber;
        private final boolean appendMolecularBarcodeNumber;
        private final int numReads;

        public ClusterToFastqWriter(File[] templateFiles, File[] sampleBarcodeFiles, File[] molecularBarcodeFiles) {
            this.templateOut = (OutputStream[])Arrays.stream(templateFiles).map(this::makeWriter).toArray(OutputStream[]::new);
            this.sampleBarcodeOut = (OutputStream[])Arrays.stream(sampleBarcodeFiles).map(this::makeWriter).toArray(OutputStream[]::new);
            this.molecularBarcodeOut = (OutputStream[])Arrays.stream(molecularBarcodeFiles).map(this::makeWriter).toArray(OutputStream[]::new);
            this.appendTemplateNumber = this.templateOut.length > 1;
            this.appendMolecularBarcodeNumber = this.molecularBarcodeOut.length > 1;
            this.numReads = this.templateOut.length + this.sampleBarcodeOut.length + this.molecularBarcodeOut.length;
        }

        private OutputStream makeWriter(File file) {
            Path outputPath = file.toPath();
            try {
                OutputStream os = Files.newOutputStream(outputPath, new OpenOption[0]);
                os = IOUtil.hasGzipFileExtension(outputPath) ? new BlockCompressedOutputStream(os, (File)null, IlluminaBasecallsToFastq.this.COMPRESSION_LEVEL) : IOUtil.maybeBufferOutputStream(os);
                if (Defaults.CREATE_MD5) {
                    os = new Md5CalculatingOutputStream(os, IOUtil.addExtension(outputPath, ".md5"));
                }
                return os;
            }
            catch (IOException ioe) {
                throw new RuntimeIOException("Error opening file: " + outputPath.toUri(), ioe);
            }
        }

        @Override
        public void write(ClusterData rec) {
            int templateIndex = 0;
            int sampleBarcodeIndex = 0;
            int molecularBarcodeIndex = 0;
            for (int i = 0; i < this.numReads; ++i) {
                String name;
                OutputStream out;
                ReadData read = rec.getRead(i);
                switch (read.getReadType()) {
                    case T: {
                        out = this.templateOut[templateIndex++];
                        name = IlluminaBasecallsToFastq.this.readNameEncoder.generateReadName(rec, this.appendTemplateNumber ? Integer.valueOf(templateIndex) : null);
                        break;
                    }
                    case B: {
                        out = this.sampleBarcodeOut[sampleBarcodeIndex++];
                        name = IlluminaBasecallsToFastq.this.readNameEncoder.generateReadName(rec, null);
                        break;
                    }
                    case M: {
                        out = this.molecularBarcodeOut[molecularBarcodeIndex++];
                        name = IlluminaBasecallsToFastq.this.readNameEncoder.generateReadName(rec, this.appendMolecularBarcodeNumber ? Integer.valueOf(molecularBarcodeIndex) : null);
                        break;
                    }
                    default: {
                        throw new IllegalStateException("Read type other than T/B/M encountered.");
                    }
                }
                this.writeSingle(out, name, read);
            }
        }

        private void writeSingle(OutputStream out, String name, ReadData read) {
            try {
                byte[] bases = read.getBases();
                byte[] quals = read.getQualities();
                int len = bases.length;
                for (int i = 0; i < len; ++i) {
                    quals[i] = (byte)SAMUtils.phredToFastq(quals[i]);
                }
                out.write(64);
                out.write(name.getBytes(StandardCharsets.UTF_8));
                out.write(10);
                out.write(bases);
                out.write(10);
                out.write(43);
                out.write(10);
                out.write(quals);
                out.write(10);
            }
            catch (IOException ioe) {
                throw new RuntimeIOException(ioe);
            }
        }

        @Override
        public void close() {
            try {
                for (OutputStream out : this.templateOut) {
                    out.close();
                }
                for (OutputStream out : this.sampleBarcodeOut) {
                    out.close();
                }
                for (OutputStream out : this.molecularBarcodeOut) {
                    out.close();
                }
            }
            catch (IOException ioe) {
                throw new RuntimeIOException(ioe);
            }
        }
    }

    private final class AsyncClusterWriter
    extends AbstractAsyncWriter<ClusterData>
    implements BasecallsConverter.ConvertedClusterDataWriter<ClusterData> {
        private final ClusterToFastqWriter writer;

        public AsyncClusterWriter(ClusterToFastqWriter out, int queueSize) {
            super(queueSize);
            this.writer = out;
        }

        @Override
        protected String getThreadNamePrefix() {
            return "FastqWriterThread-";
        }

        @Override
        protected void synchronouslyWrite(ClusterData item) {
            this.writer.write(item);
        }

        @Override
        protected void synchronouslyClose() {
            this.writer.close();
        }
    }

    private static final class NoOpClusterConverter
    implements BasecallsConverter.ClusterDataConverter<ClusterData> {
        private NoOpClusterConverter() {
        }

        @Override
        public ClusterData convertClusterToOutputRecord(ClusterData cluster) {
            return cluster;
        }
    }

    public static enum ReadNameFormat {
        CASAVA_1_8,
        ILLUMINA;

    }
}

