/*
 * Decompiled with CFR 0.152.
 */
package picard.illumina;

import htsjdk.samtools.util.IOUtil;
import htsjdk.samtools.util.SortingCollection;
import java.io.File;
import java.util.ArrayList;
import java.util.Comparator;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import picard.PicardException;
import picard.illumina.BasecallsConverter;
import picard.illumina.parser.BaseIlluminaDataProvider;
import picard.illumina.parser.ClusterData;
import picard.illumina.parser.ReadStructure;
import picard.illumina.parser.readers.BclQualityEvaluationStrategy;

public class SortedBasecallsConverter<CLUSTER_OUTPUT_RECORD>
extends BasecallsConverter<CLUSTER_OUTPUT_RECORD> {
    private final Comparator<CLUSTER_OUTPUT_RECORD> outputRecordComparator;
    private final SortingCollection.Codec<CLUSTER_OUTPUT_RECORD> codecPrototype;
    private final Class<CLUSTER_OUTPUT_RECORD> outputRecordClass;
    private final int maxReadsInRamPerTile;
    private final List<File> tmpDirs;

    protected SortedBasecallsConverter(File basecallsDir, File barcodesDir, int lane, ReadStructure readStructure, Map<String, ? extends BasecallsConverter.ConvertedClusterDataWriter<CLUSTER_OUTPUT_RECORD>> barcodeRecordWriterMap, boolean demultiplex, int maxReadsInRamPerTile, List<File> tmpDirs, int numThreads, Integer firstTile, Integer tileLimit, Comparator<CLUSTER_OUTPUT_RECORD> outputRecordComparator, SortingCollection.Codec<CLUSTER_OUTPUT_RECORD> codecPrototype, Class<CLUSTER_OUTPUT_RECORD> outputRecordClass, BclQualityEvaluationStrategy bclQualityEvaluationStrategy, boolean ignoreUnexpectedBarcodes, boolean applyEamssFiltering, boolean includeNonPfReads) {
        super(basecallsDir, barcodesDir, lane, readStructure, barcodeRecordWriterMap, demultiplex, numThreads, firstTile, tileLimit, bclQualityEvaluationStrategy, ignoreUnexpectedBarcodes, applyEamssFiltering, includeNonPfReads, numThreads);
        this.tmpDirs = tmpDirs;
        this.maxReadsInRamPerTile = maxReadsInRamPerTile;
        this.codecPrototype = codecPrototype;
        this.outputRecordComparator = outputRecordComparator;
        this.outputRecordClass = outputRecordClass;
    }

    @Override
    public void processTilesAndWritePerSampleOutputs(Set<String> barcodes) {
        for (Integer tile : this.tiles) {
            this.tileReadExecutor.submit(new TileProcessor(tile, barcodes));
        }
        this.awaitTileProcessingCompletion();
    }

    private class TileProcessor
    implements Runnable {
        private final int tileNum;
        private final Map<String, SortingCollection<CLUSTER_OUTPUT_RECORD>> barcodeToRecordCollection;

        TileProcessor(int tileNum, Set<String> barcodes) {
            this.tileNum = tileNum;
            this.barcodeToRecordCollection = new HashMap(barcodes.size(), 1.0f);
            for (String barcode : barcodes) {
                SortingCollection recordCollection = this.createSortingCollection();
                this.barcodeToRecordCollection.put(barcode, recordCollection);
            }
        }

        @Override
        public void run() {
            BaseIlluminaDataProvider dataProvider = SortedBasecallsConverter.this.factory.makeDataProvider(this.tileNum);
            while (dataProvider.hasNext()) {
                ClusterData cluster = (ClusterData)dataProvider.next();
                SortedBasecallsConverter.this.readProgressLogger.record(null, 0);
                if (!SortedBasecallsConverter.this.includeNonPfReads && !cluster.isPf().booleanValue()) continue;
                this.addRecord(cluster.getMatchedBarcode(), SortedBasecallsConverter.this.converter.convertClusterToOutputRecord(cluster));
            }
            dataProvider.close();
            ArrayList writerList = new ArrayList();
            this.barcodeToRecordCollection.forEach((barcode, value) -> {
                value.doneAdding();
                BasecallsConverter.ConvertedClusterDataWriter writer = (BasecallsConverter.ConvertedClusterDataWriter)SortedBasecallsConverter.this.barcodeRecordWriterMap.get(barcode);
                BasecallsConverter.log.debug("Writing out barcode " + barcode);
                writerList.add(new SortedRecordToWriterPump(writer, value));
            });
            SortedBasecallsConverter.this.notifyWorkComplete(this.tileNum, writerList);
            BasecallsConverter.log.debug("Finished processing tile " + this.tileNum);
        }

        private synchronized void addRecord(String barcode, CLUSTER_OUTPUT_RECORD record) {
            SortingCollection recordCollection = this.barcodeToRecordCollection.get(barcode);
            if (recordCollection != null) {
                recordCollection.add(record);
            } else if (!SortedBasecallsConverter.this.ignoreUnexpectedBarcodes) {
                throw new PicardException(String.format("Read records with barcode %s, but this barcode was not expected.  (Is it referenced in the parameters file?)", barcode));
            }
        }

        private synchronized SortingCollection<CLUSTER_OUTPUT_RECORD> createSortingCollection() {
            int maxRecordsInRam = Math.max(1, SortedBasecallsConverter.this.maxReadsInRamPerTile / SortedBasecallsConverter.this.barcodeRecordWriterMap.size());
            return SortingCollection.newInstanceFromPaths(SortedBasecallsConverter.this.outputRecordClass, SortedBasecallsConverter.this.codecPrototype.clone(), SortedBasecallsConverter.this.outputRecordComparator, maxRecordsInRam, IOUtil.filesToPaths(SortedBasecallsConverter.this.tmpDirs));
        }
    }

    private class SortedRecordToWriterPump
    implements Runnable {
        private final SortingCollection<CLUSTER_OUTPUT_RECORD> recordCollection;
        private final BasecallsConverter.ConvertedClusterDataWriter<CLUSTER_OUTPUT_RECORD> writer;

        SortedRecordToWriterPump(BasecallsConverter.ConvertedClusterDataWriter<CLUSTER_OUTPUT_RECORD> writer, SortingCollection<CLUSTER_OUTPUT_RECORD> recordCollection) {
            this.writer = writer;
            this.recordCollection = recordCollection;
        }

        @Override
        public void run() {
            for (Object record : this.recordCollection) {
                this.writer.write(record);
                SortedBasecallsConverter.this.writeProgressLogger.record(null, 0);
            }
            this.recordCollection.cleanup();
        }
    }
}

