/*
 * Decompiled with CFR 0.152.
 */
package picard.illumina;

import java.io.File;
import java.util.ArrayDeque;
import java.util.Collections;
import java.util.Map;
import java.util.Queue;
import java.util.Set;
import picard.PicardException;
import picard.illumina.BasecallsConverter;
import picard.illumina.parser.BaseIlluminaDataProvider;
import picard.illumina.parser.ClusterData;
import picard.illumina.parser.ReadStructure;
import picard.illumina.parser.readers.BclQualityEvaluationStrategy;

public class UnsortedBasecallsConverter<CLUSTER_OUTPUT_RECORD>
extends BasecallsConverter<CLUSTER_OUTPUT_RECORD> {
    private int tilesProcessing = 0;

    protected UnsortedBasecallsConverter(File basecallsDir, File barcodesDir, int lane, ReadStructure readStructure, Map<String, ? extends BasecallsConverter.ConvertedClusterDataWriter<CLUSTER_OUTPUT_RECORD>> barcodeRecordWriterMap, boolean demultiplex, int numThreads, Integer firstTile, Integer tileLimit, BclQualityEvaluationStrategy bclQualityEvaluationStrategy, boolean ignoreUnexpectedBarcodes, boolean applyEamssFiltering, boolean includeNonPfReads) {
        super(basecallsDir, barcodesDir, lane, readStructure, barcodeRecordWriterMap, demultiplex, numThreads, firstTile, tileLimit, bclQualityEvaluationStrategy, ignoreUnexpectedBarcodes, applyEamssFiltering, includeNonPfReads, 1);
    }

    @Override
    public void processTilesAndWritePerSampleOutputs(Set<String> barcodes) {
        int MAX_TILES_IN_CACHE = 4;
        int tilesSubmitted = 0;
        while (tilesSubmitted < this.tiles.size()) {
            if (this.tilesProcessing < MAX_TILES_IN_CACHE) {
                int tile = (Integer)this.tiles.get(tilesSubmitted);
                this.tileReadExecutor.submit(new TileReadProcessor(tile));
                ++this.tilesProcessing;
                ++tilesSubmitted;
                continue;
            }
            try {
                Thread.sleep(100L);
            }
            catch (InterruptedException e) {
                throw new PicardException("Tile processing thread interrupted: " + e.getMessage());
            }
        }
        this.awaitTileProcessingCompletion();
    }

    private class RecordToWriterPump
    implements Runnable {
        private final Queue<ClusterData> clusterData;

        RecordToWriterPump(Queue<ClusterData> clusterData) {
            this.clusterData = clusterData;
        }

        @Override
        public void run() {
            ClusterData cluster;
            while ((cluster = this.clusterData.poll()) != null) {
                if (!UnsortedBasecallsConverter.this.includeNonPfReads && !cluster.isPf().booleanValue()) continue;
                ((BasecallsConverter.ConvertedClusterDataWriter)UnsortedBasecallsConverter.this.barcodeRecordWriterMap.get(cluster.getMatchedBarcode())).write(UnsortedBasecallsConverter.this.converter.convertClusterToOutputRecord(cluster));
                UnsortedBasecallsConverter.this.writeProgressLogger.record(null, 0);
            }
            UnsortedBasecallsConverter.this.tilesProcessing--;
        }
    }

    private class TileReadProcessor
    implements Runnable {
        private final int tileNum;

        TileReadProcessor(int tileNum) {
            this.tileNum = tileNum;
        }

        @Override
        public void run() {
            ArrayDeque<ClusterData> queue = new ArrayDeque<ClusterData>();
            BaseIlluminaDataProvider dataProvider = UnsortedBasecallsConverter.this.factory.makeDataProvider(this.tileNum);
            while (dataProvider.hasNext()) {
                ClusterData cluster = (ClusterData)dataProvider.next();
                UnsortedBasecallsConverter.this.readProgressLogger.record(null, 0);
                if (!UnsortedBasecallsConverter.this.includeNonPfReads && !cluster.isPf().booleanValue()) continue;
                queue.add(cluster);
            }
            dataProvider.close();
            UnsortedBasecallsConverter.this.notifyWorkComplete(this.tileNum, Collections.singletonList(new RecordToWriterPump(queue)));
        }
    }
}

