/*
 * Decompiled with CFR 0.152.
 */
package picard.sam;

import htsjdk.samtools.BAMIndexMetaData;
import htsjdk.samtools.util.IOUtil;
import htsjdk.samtools.util.Log;
import java.io.File;
import org.broadinstitute.barclay.argparser.Argument;
import org.broadinstitute.barclay.argparser.CommandLineProgramProperties;
import org.broadinstitute.barclay.help.DocumentedFeature;
import picard.cmdline.CommandLineProgram;
import picard.cmdline.programgroups.DiagnosticsAndQCProgramGroup;

@CommandLineProgramProperties(summary="Generate index statistics from a BAM fileThis tool calculates statistics from a BAM index (.bai) file, emulating the behavior of the \"samtools idxstats\" command. The statistics collected include counts of aligned and unaligned reads as well as all records with no start coordinate. The input to the tool is the BAM file name but it must be accompanied by a corresponding index file.<br /><h4>Usage example:</h4><pre>java -jar picard.jar BamIndexStats \\<br />      I=input.bam \\<br />      O=output</pre><hr />", oneLineSummary="Generate index statistics from a BAM file", programGroup=DiagnosticsAndQCProgramGroup.class)
@DocumentedFeature
public class BamIndexStats
extends CommandLineProgram {
    static final String USAGE_SUMMARY = "Generate index statistics from a BAM file";
    static final String USAGE_DETAILS = "This tool calculates statistics from a BAM index (.bai) file, emulating the behavior of the \"samtools idxstats\" command. The statistics collected include counts of aligned and unaligned reads as well as all records with no start coordinate. The input to the tool is the BAM file name but it must be accompanied by a corresponding index file.<br /><h4>Usage example:</h4><pre>java -jar picard.jar BamIndexStats \\<br />      I=input.bam \\<br />      O=output</pre><hr />";
    private static final Log log = Log.getInstance(BamIndexStats.class);
    @Argument(shortName="I", doc="A BAM file to process.")
    public File INPUT;

    @Override
    protected int doWork() {
        if (this.INPUT.getName().endsWith(".bai")) {
            log.warn("INPUT should be the BAM file name, not its index file");
        }
        IOUtil.assertFileIsReadable(this.INPUT);
        BAMIndexMetaData.printIndexStats(this.INPUT);
        return 0;
    }
}

