/*
 * Decompiled with CFR 0.152.
 */
package picard.sam;

import htsjdk.samtools.SAMRecord;
import htsjdk.samtools.SAMTag;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import java.util.List;

class HitsForInsert {
    private static final HitIndexComparator comparator = new HitIndexComparator();
    final List<SAMRecord> firstOfPairOrFragment = new ArrayList<SAMRecord>();
    final List<SAMRecord> secondOfPair = new ArrayList<SAMRecord>();
    private final List<SAMRecord> supplementalFirstOfPairOrFragment = new ArrayList<SAMRecord>();
    private final List<SAMRecord> supplementalSecondOfPair = new ArrayList<SAMRecord>();

    HitsForInsert() {
    }

    public String getReadName() {
        return this.getRepresentativeRead().getReadName();
    }

    public boolean isPaired() {
        return this.getRepresentativeRead().getReadPairedFlag();
    }

    public SAMRecord getRepresentativeRead() {
        for (SAMRecord rec : this.firstOfPairOrFragment) {
            if (rec == null) continue;
            return rec;
        }
        for (SAMRecord rec : this.secondOfPair) {
            if (rec == null) continue;
            return rec;
        }
        throw new IllegalStateException("Should not be called if numHits == 0");
    }

    public int numHits() {
        return Math.max(this.firstOfPairOrFragment.size(), this.secondOfPair.size());
    }

    public boolean hasSupplementalHits() {
        return !this.supplementalFirstOfPairOrFragment.isEmpty() || !this.supplementalSecondOfPair.isEmpty();
    }

    public SAMRecord getFirstOfPair(int i) {
        if (i >= this.firstOfPairOrFragment.size()) {
            return null;
        }
        return this.firstOfPairOrFragment.get(i);
    }

    public void addFirstOfPairOrFragment(SAMRecord rec) {
        this.firstOfPairOrFragment.add(rec);
    }

    public void addSecondOfPair(SAMRecord rec) {
        this.secondOfPair.add(rec);
    }

    public void addSupplementalFirstOfPairOrFragment(SAMRecord rec) {
        this.supplementalFirstOfPairOrFragment.add(rec);
    }

    public void addSupplementalSecondOfPair(SAMRecord rec) {
        this.supplementalSecondOfPair.add(rec);
    }

    public SAMRecord getFragment(int i) {
        SAMRecord samRecord = this.firstOfPairOrFragment.get(i);
        if (samRecord.getReadPairedFlag()) {
            throw new UnsupportedOperationException("getFragment called for paired read: " + samRecord.toString());
        }
        return samRecord;
    }

    public SAMRecord getSecondOfPair(int i) {
        if (i >= this.secondOfPair.size()) {
            return null;
        }
        return this.secondOfPair.get(i);
    }

    public int getIndexOfEarliestPrimary() {
        for (int i = 0; i < this.numHits(); ++i) {
            boolean isPrimaryAlignment;
            SAMRecord firstAligned = this.getFirstOfPair(i);
            SAMRecord secondAligned = this.getSecondOfPair(i);
            boolean bl = isPrimaryAlignment = firstAligned != null && !firstAligned.isSecondaryOrSupplementary() || secondAligned != null && !secondAligned.isSecondaryOrSupplementary();
            if (!isPrimaryAlignment) continue;
            return i;
        }
        return -1;
    }

    public void setPrimaryAlignment(int primaryAlignmentIndex) {
        if (primaryAlignmentIndex < 0 || primaryAlignmentIndex >= this.numHits()) {
            throw new IllegalArgumentException("primaryAlignmentIndex(" + primaryAlignmentIndex + ") out of range for numHits(" + this.numHits() + ")");
        }
        for (int i = 0; i < this.numHits(); ++i) {
            boolean notPrimary;
            boolean bl = notPrimary = i != primaryAlignmentIndex;
            if (this.getFirstOfPair(i) != null) {
                this.getFirstOfPair(i).setNotPrimaryAlignmentFlag(notPrimary);
            }
            if (this.getSecondOfPair(i) == null) continue;
            this.getSecondOfPair(i).setNotPrimaryAlignmentFlag(notPrimary);
        }
    }

    public void coordinateByHitIndex() {
        Collections.sort(this.firstOfPairOrFragment, comparator);
        Collections.sort(this.secondOfPair, comparator);
        for (int i = 0; i < Math.min(this.firstOfPairOrFragment.size(), this.secondOfPair.size()); ++i) {
            Integer leftHi = this.firstOfPairOrFragment.get(i).getIntegerAttribute(SAMTag.HI.name());
            Integer rightHi = this.secondOfPair.get(i).getIntegerAttribute(SAMTag.HI.name());
            if (leftHi != null) {
                if (rightHi == null) continue;
                if (leftHi < rightHi) {
                    this.secondOfPair.add(i, null);
                    continue;
                }
                if (rightHi >= leftHi) continue;
                this.firstOfPairOrFragment.add(i, null);
                continue;
            }
            if (rightHi != null) {
                this.firstOfPairOrFragment.add(i, null);
                continue;
            }
            this.secondOfPair.add(i, null);
        }
        int hi = 0;
        for (int i = 0; i < this.numHits(); ++i) {
            SAMRecord first = this.getFirstOfPair(i);
            SAMRecord second = this.getSecondOfPair(i);
            if (first != null && second != null) {
                first.setAttribute(SAMTag.HI.name(), (Object)i);
                second.setAttribute(SAMTag.HI.name(), (Object)i);
                ++hi;
                continue;
            }
            if (first != null) {
                first.setAttribute(SAMTag.HI.name(), null);
                continue;
            }
            second.setAttribute(SAMTag.HI.name(), null);
        }
    }

    private NumPrimaryAlignmentState tallyPrimaryAlignments(List<SAMRecord> records) {
        boolean seenPrimary = false;
        for (int i = 0; i < records.size(); ++i) {
            if (records.get(i) == null || records.get(i).isSecondaryOrSupplementary()) continue;
            if (seenPrimary) {
                return NumPrimaryAlignmentState.MORE_THAN_ONE;
            }
            seenPrimary = true;
        }
        if (seenPrimary) {
            return NumPrimaryAlignmentState.ONE;
        }
        return NumPrimaryAlignmentState.NONE;
    }

    public NumPrimaryAlignmentState tallyPrimaryAlignments(boolean firstEnd) {
        if (firstEnd) {
            return this.tallyPrimaryAlignments(this.firstOfPairOrFragment);
        }
        return this.tallyPrimaryAlignments(this.secondOfPair);
    }

    List<SAMRecord> getSupplementalFirstOfPairOrFragment() {
        return this.supplementalFirstOfPairOrFragment;
    }

    List<SAMRecord> getSupplementalSecondOfPair() {
        return this.supplementalSecondOfPair;
    }

    private static class HitIndexComparator
    implements Comparator<SAMRecord> {
        private HitIndexComparator() {
        }

        @Override
        public int compare(SAMRecord rec1, SAMRecord rec2) {
            Integer hi1 = rec1.getIntegerAttribute(SAMTag.HI.name());
            Integer hi2 = rec2.getIntegerAttribute(SAMTag.HI.name());
            if (hi1 == null) {
                if (hi2 == null) {
                    return 0;
                }
                return 1;
            }
            if (hi2 == null) {
                return -1;
            }
            return hi1.compareTo(hi2);
        }
    }

    public static enum NumPrimaryAlignmentState {
        NONE,
        ONE,
        MORE_THAN_ONE;

    }
}

