/*
 * Decompiled with CFR 0.152.
 */
package picard.sam;

import htsjdk.samtools.Cigar;
import htsjdk.samtools.CigarElement;
import htsjdk.samtools.CigarOperator;
import htsjdk.samtools.SAMRecord;
import htsjdk.samtools.SAMRecordQueryNameComparator;
import htsjdk.samtools.SAMTag;
import htsjdk.samtools.SAMUtils;
import htsjdk.samtools.filter.FilteringSamIterator;
import htsjdk.samtools.filter.SamRecordFilter;
import htsjdk.samtools.util.CloseableIterator;
import htsjdk.samtools.util.PeekableIterator;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.NoSuchElementException;
import picard.PicardException;
import picard.sam.HitsForInsert;
import picard.sam.PrimaryAlignmentSelectionStrategy;

class MultiHitAlignedReadIterator
implements CloseableIterator<HitsForInsert> {
    private final PeekableIterator<SAMRecord> peekIterator;
    private final SAMRecordQueryNameComparator queryNameComparator = new SAMRecordQueryNameComparator();
    private final PrimaryAlignmentSelectionStrategy primaryAlignmentSelectionStrategy;
    private HitsForInsert theNext = null;

    MultiHitAlignedReadIterator(CloseableIterator<SAMRecord> querynameOrderIterator, PrimaryAlignmentSelectionStrategy primaryAlignmentSelectionStrategy) {
        this.primaryAlignmentSelectionStrategy = primaryAlignmentSelectionStrategy;
        this.peekIterator = new PeekableIterator<SAMRecord>(new FilteringSamIterator(querynameOrderIterator, new SamRecordFilter(){

            @Override
            public boolean filterOut(SAMRecord record) {
                return record.getReadUnmappedFlag() || SAMUtils.cigarMapsNoBasesToRef(record.getCigar());
            }

            @Override
            public boolean filterOut(SAMRecord first, SAMRecord second) {
                return !(!first.getReadUnmappedFlag() && !SAMUtils.cigarMapsNoBasesToRef(first.getCigar()) || !second.getReadUnmappedFlag() && !SAMUtils.cigarMapsNoBasesToRef(second.getCigar()));
            }
        }));
        this.advance();
    }

    @Override
    public void close() {
        this.peekIterator.close();
    }

    @Override
    public boolean hasNext() {
        return this.theNext != null;
    }

    @Override
    public HitsForInsert next() {
        if (!this.hasNext()) {
            throw new NoSuchElementException();
        }
        HitsForInsert ret = this.theNext;
        this.advance();
        return ret;
    }

    private void advance() {
        while (this.peekIterator.hasNext()) {
            this.theNext = this.nextMaybeEmpty();
            if (this.theNext.numHits() <= 0) continue;
            return;
        }
        this.theNext = null;
    }

    private HitsForInsert nextMaybeEmpty() {
        if (!this.peekIterator.hasNext()) {
            throw new IllegalStateException();
        }
        String readName = this.peekIterator.peek().getReadName();
        HitsForInsert hits = new HitsForInsert();
        Boolean isPaired = null;
        do {
            SAMRecord rec = this.peekIterator.next();
            this.replaceHardWithSoftClips(rec);
            if (this.peekIterator.hasNext() && this.queryNameComparator.fileOrderCompare(rec, this.peekIterator.peek()) > 0) {
                throw new IllegalStateException("Underlying iterator is not queryname sorted: " + rec + " > " + this.peekIterator.peek());
            }
            if (isPaired == null) {
                isPaired = rec.getReadPairedFlag();
            } else if (isPaired.booleanValue() != rec.getReadPairedFlag()) {
                throw new PicardException("Got a mix of paired and unpaired alignments for read " + readName);
            }
            if (!rec.getReadPairedFlag() || rec.getFirstOfPairFlag()) {
                if (rec.getSupplementaryAlignmentFlag()) {
                    hits.addSupplementalFirstOfPairOrFragment(rec);
                    continue;
                }
                hits.addFirstOfPairOrFragment(rec);
                continue;
            }
            if (rec.getSecondOfPairFlag()) {
                if (rec.getSupplementaryAlignmentFlag()) {
                    hits.addSupplementalSecondOfPair(rec);
                    continue;
                }
                hits.addSecondOfPair(rec);
                continue;
            }
            throw new PicardException("Read is marked as pair but neither first or second: " + readName);
        } while (this.peekIterator.hasNext() && this.peekIterator.peek().getReadName().equals(readName));
        if (hits.numHits() <= 1) {
            if (hits.getFirstOfPair(0) != null) {
                hits.getFirstOfPair(0).setAttribute(SAMTag.HI.name(), null);
                hits.getFirstOfPair(0).setNotPrimaryAlignmentFlag(false);
            }
            if (hits.getSecondOfPair(0) != null) {
                hits.getSecondOfPair(0).setAttribute(SAMTag.HI.name(), null);
                hits.getSecondOfPair(0).setNotPrimaryAlignmentFlag(false);
            }
        } else {
            this.primaryAlignmentSelectionStrategy.pickPrimaryAlignment(hits);
        }
        return hits;
    }

    private void replaceHardWithSoftClips(SAMRecord rec) {
        int endHardClip;
        if (rec.getReadUnmappedFlag()) {
            return;
        }
        if (rec.getCigar().isEmpty()) {
            return;
        }
        List<CigarElement> elements = rec.getCigar().getCigarElements();
        CigarElement first = elements.get(0);
        CigarElement last = elements.size() == 1 ? null : elements.get(elements.size() - 1);
        int startHardClip = first.getOperator() == CigarOperator.H ? first.getLength() : 0;
        int n = endHardClip = last != null && last.getOperator() == CigarOperator.H ? last.getLength() : 0;
        if (startHardClip + endHardClip > 0) {
            int len = rec.getReadBases().length + startHardClip + endHardClip;
            byte[] bases = new byte[len];
            Arrays.fill(bases, (byte)78);
            System.arraycopy(rec.getReadBases(), 0, bases, startHardClip, rec.getReadBases().length);
            byte[] quals = new byte[len];
            Arrays.fill(quals, (byte)2);
            System.arraycopy(rec.getBaseQualities(), 0, quals, startHardClip, rec.getBaseQualities().length);
            elements = new ArrayList<CigarElement>(elements);
            if (startHardClip > 0) {
                elements.set(0, new CigarElement(first.getLength(), CigarOperator.S));
            }
            if (endHardClip > 0) {
                elements.set(elements.size() - 1, new CigarElement(last.getLength(), CigarOperator.S));
            }
            rec.setReadBases(bases);
            rec.setBaseQualities(quals);
            rec.setCigar(new Cigar(elements));
        }
    }

    @Override
    public void remove() {
        throw new UnsupportedOperationException();
    }
}

