/*
 * Decompiled with CFR 0.152.
 */
package picard.sam.SamErrorMetric;

import htsjdk.samtools.util.QualityUtil;
import picard.analysis.MergeableMetricBase;

public class ErrorMetric
extends MergeableMetricBase {
    protected static double PRIOR_ERROR = 0.001;
    @MergeableMetricBase.MergingIsManual
    public String COVARIATE;
    @MergeableMetricBase.MergeByAdding
    public long TOTAL_BASES;

    public ErrorMetric(String covariate, long totalBases) {
        this.TOTAL_BASES = totalBases;
        this.COVARIATE = covariate;
    }

    public ErrorMetric() {
    }

    public static void setPriorError(double priorError) {
        PRIOR_ERROR = priorError;
    }

    protected int computeQScore(long numberOfErrors) {
        return this.computeQScore(numberOfErrors, this.TOTAL_BASES);
    }

    protected int computeQScore(long numberOfErrors, long nTotalBases) {
        return QualityUtil.getPhredScoreFromErrorProbability(((double)numberOfErrors + PRIOR_ERROR) / ((double)nTotalBases + 1.0));
    }
}

