/*
 * Decompiled with CFR 0.152.
 */
package picard.sam.markduplicates;

import htsjdk.samtools.util.Histogram;
import java.util.ArrayList;
import java.util.List;
import picard.sam.markduplicates.ElcDuplicatesFinder;
import picard.sam.markduplicates.EstimateLibraryComplexity;
import picard.sam.markduplicates.util.OpticalDuplicateFinder;

class ElcIdenticalBasesDuplicatesFinder
extends ElcDuplicatesFinder {
    private boolean useBarcodes;

    ElcIdenticalBasesDuplicatesFinder(double maxDiffRate, int maxReadLength, int minIdenticalBases, boolean useBarcodes, OpticalDuplicateFinder opticalDuplicateFinder) {
        super(maxDiffRate, maxReadLength, minIdenticalBases, opticalDuplicateFinder);
        this.useBarcodes = useBarcodes;
    }

    @Override
    void searchDuplicates(List<EstimateLibraryComplexity.PairedReadSequence> sequences, Histogram<Integer> duplicationHisto, Histogram<Integer> opticalHisto) {
        for (int i = 0; i < sequences.size(); ++i) {
            EstimateLibraryComplexity.PairedReadSequence lhs = sequences.get(i);
            if (lhs == null) continue;
            ArrayList<EstimateLibraryComplexity.PairedReadSequence> dupes = new ArrayList<EstimateLibraryComplexity.PairedReadSequence>();
            for (int j = i + 1; j < sequences.size(); ++j) {
                EstimateLibraryComplexity.PairedReadSequence rhs = sequences.get(j);
                if (rhs == null || !this.matches(lhs, rhs, this.maxDiffRate, this.useBarcodes)) continue;
                dupes.add(rhs);
                sequences.set(j, null);
            }
            this.fillHistogram(duplicationHisto, opticalHisto, lhs, dupes);
        }
    }

    private boolean matches(EstimateLibraryComplexity.PairedReadSequence lhs, EstimateLibraryComplexity.PairedReadSequence rhs, double maxDiffRate, boolean useBarcodes) {
        int i;
        int read1Length = this.minLength(lhs.read1, rhs.read1);
        int read2Length = this.minLength(lhs.read2, rhs.read2);
        int maxErrors = (int)Math.floor((double)(read1Length + read2Length) * maxDiffRate);
        int errors = 0;
        if (useBarcodes) {
            EstimateLibraryComplexity.PairedReadSequenceWithBarcodes lhsWithBarcodes = (EstimateLibraryComplexity.PairedReadSequenceWithBarcodes)lhs;
            EstimateLibraryComplexity.PairedReadSequenceWithBarcodes rhsWithBarcodes = (EstimateLibraryComplexity.PairedReadSequenceWithBarcodes)rhs;
            if (lhsWithBarcodes.barcode != rhsWithBarcodes.barcode || lhsWithBarcodes.readOneBarcode != rhsWithBarcodes.readOneBarcode || lhsWithBarcodes.readTwoBarcode != rhsWithBarcodes.readTwoBarcode) {
                return false;
            }
        }
        for (i = this.minIdenticalBases; i < read1Length; ++i) {
            if (lhs.read1[i] == rhs.read1[i] || ++errors <= maxErrors) continue;
            return false;
        }
        for (i = this.minIdenticalBases; i < read2Length; ++i) {
            if (lhs.read2[i] == rhs.read2[i] || ++errors <= maxErrors) continue;
            return false;
        }
        return true;
    }
}

