/*
 * Decompiled with CFR 0.152.
 */
package picard.vcf;

import htsjdk.samtools.SAMSequenceDictionary;
import htsjdk.samtools.util.PeekableIterator;
import htsjdk.variant.variantcontext.VariantContext;
import htsjdk.variant.variantcontext.VariantContextComparator;
import java.util.Iterator;
import java.util.Optional;

public class PairedVariantSubContextIterator
implements Iterator<VcfTuple> {
    private final PeekableIterator<VariantContext> leftIterator;
    private final String leftSample;
    private final PeekableIterator<VariantContext> rightIterator;
    private final String rightSample;
    private final VariantContextComparator comparator;

    public PairedVariantSubContextIterator(Iterator<VariantContext> leftIterator, String leftSample, Iterator<VariantContext> rightIterator, String rightSample, SAMSequenceDictionary dict) {
        this.leftIterator = new PeekableIterator<VariantContext>(leftIterator);
        this.leftSample = leftSample;
        this.rightIterator = new PeekableIterator<VariantContext>(rightIterator);
        this.rightSample = rightSample;
        this.comparator = new VariantContextComparator(dict);
    }

    @Override
    public boolean hasNext() {
        return this.leftIterator.hasNext() || this.rightIterator.hasNext();
    }

    @Override
    public VcfTuple next() {
        Optional rightVariantContext;
        if (!this.hasNext()) {
            throw new IllegalStateException("next() called while hasNext() is false.");
        }
        Optional leftVariantContext = this.leftIterator.hasNext() ? Optional.of(this.leftIterator.peek()) : Optional.empty();
        Optional<Object> optional = rightVariantContext = this.rightIterator.hasNext() ? Optional.of(this.rightIterator.peek()) : Optional.empty();
        if (!leftVariantContext.isPresent() && !rightVariantContext.isPresent()) {
            throw new IllegalStateException("BUG: Both contexts empty.");
        }
        if (!leftVariantContext.isPresent()) {
            return new VcfTuple(Optional.empty(), this.rightIterator.next().subContextFromSample(this.rightSample));
        }
        if (!rightVariantContext.isPresent()) {
            return new VcfTuple(this.leftIterator.next().subContextFromSample(this.leftSample), Optional.empty());
        }
        int ordering = this.comparator.compare((VariantContext)leftVariantContext.get(), (VariantContext)rightVariantContext.get());
        if (ordering == 0) {
            return new VcfTuple(this.leftIterator.next().subContextFromSample(this.leftSample), this.rightIterator.next().subContextFromSample(this.rightSample));
        }
        if (ordering < 0) {
            return new VcfTuple(this.leftIterator.next().subContextFromSample(this.leftSample), Optional.empty());
        }
        return new VcfTuple(Optional.empty(), this.rightIterator.next().subContextFromSample(this.rightSample));
    }

    @Override
    public void remove() {
        throw new UnsupportedOperationException();
    }

    public static class VcfTuple {
        public final Optional<VariantContext> leftVariantContext;
        public final Optional<VariantContext> rightVariantContext;

        private VcfTuple(Optional<VariantContext> leftVariantContext, Optional<VariantContext> rightVariantContext) {
            this.leftVariantContext = leftVariantContext;
            this.rightVariantContext = rightVariantContext;
        }

        VcfTuple(VariantContext leftVariantContext, VariantContext rightVariantContext) {
            this(Optional.of(leftVariantContext), Optional.of(rightVariantContext));
        }

        VcfTuple(Optional<VariantContext> leftVariantContext, VariantContext rightVariantContext) {
            this(leftVariantContext, Optional.of(rightVariantContext));
        }

        VcfTuple(VariantContext leftVariantContext, Optional<VariantContext> rightVariantContext) {
            this(Optional.of(leftVariantContext), rightVariantContext);
        }
    }
}

