/*
 * Decompiled with CFR 0.152.
 */
package picard.vcf;

import htsjdk.samtools.SAMFileHeader;
import htsjdk.samtools.util.IOUtil;
import htsjdk.samtools.util.Interval;
import htsjdk.samtools.util.IntervalList;
import htsjdk.samtools.util.IntervalListWriter;
import htsjdk.samtools.util.IterableAdapter;
import htsjdk.samtools.util.Log;
import htsjdk.variant.vcf.VCFFileReader;
import java.io.File;
import java.io.IOException;
import java.util.Iterator;
import org.broadinstitute.barclay.argparser.Argument;
import org.broadinstitute.barclay.argparser.CommandLineProgramProperties;
import org.broadinstitute.barclay.help.DocumentedFeature;
import picard.PicardException;
import picard.cmdline.CommandLineProgram;
import picard.cmdline.programgroups.VariantManipulationProgramGroup;

@CommandLineProgramProperties(summary="This tool creates a Picard Interval List from a VCF or BCF. It is important that the file extension is included as the file format is determined by the fileextension. Variants that were filtered can be included in the output interval list by settingINCLUDE_FILTERED to true.<p><h4>Usage example:</h4><pre>java -jar picard.jar VcfToIntervalList <br />      I=sample.vcf <br />      O=sample.interval_list <br /></pre>", oneLineSummary="Converts a VCF or BCF file to a Picard Interval List", programGroup=VariantManipulationProgramGroup.class)
@DocumentedFeature
public class VcfToIntervalList
extends CommandLineProgram {
    static final String USAGE_SUMMARY = "Converts a VCF or BCF file to a Picard Interval List";
    static final String USAGE_DETAILS = "This tool creates a Picard Interval List from a VCF or BCF. It is important that the file extension is included as the file format is determined by the fileextension. Variants that were filtered can be included in the output interval list by settingINCLUDE_FILTERED to true.<p><h4>Usage example:</h4><pre>java -jar picard.jar VcfToIntervalList <br />      I=sample.vcf <br />      O=sample.interval_list <br /></pre>";
    public static final String INCLUDE_FILTERED_SHORT_NAME = "IF";
    public static final Log LOG = Log.getInstance(VcfToIntervalList.class);
    @Argument(doc="The BCF or VCF input file. The file format is determined by file extension.", shortName="I")
    public File INPUT;
    @Argument(shortName="O", doc="The output Picard Interval List.")
    public File OUTPUT;
    @Argument(doc="Controls the naming of the resulting intervals. When set to CONCAT_ALL (the default), each resulting interval will be named the concatenation of the variant ID fields (if present), or 'interval-<number>' (if not) with a pipe '|' separator. If set to USE_FIRST, only the first name will be used.")
    public static VARIANT_ID_TYPES VARIANT_ID_METHOD = VARIANT_ID_TYPES.CONCAT_ALL;
    @Argument(shortName="IF", doc="Include variants that were filtered in the output interval list.", optional=true)
    public boolean INCLUDE_FILTERED = false;

    @Override
    protected int doWork() {
        IOUtil.assertFileIsReadable(this.INPUT);
        IOUtil.assertFileIsWritable(this.OUTPUT);
        boolean concatenate_ids = VARIANT_ID_METHOD == VARIANT_ID_TYPES.CONCAT_ALL;
        try (VCFFileReader vcfReader = new VCFFileReader(this.INPUT.toPath(), false);){
            Iterator<Interval> samFileIterator = VCFFileReader.toIntervals(vcfReader, this.INCLUDE_FILTERED);
            try (IntervalListWriter writer = new IntervalListWriter(this.OUTPUT.toPath(), new SAMFileHeader(vcfReader.getFileHeader().getSequenceDictionary()));){
                IntervalList.IntervalMergerIterator mergingIterator = new IntervalList.IntervalMergerIterator(samFileIterator, true, false, concatenate_ids);
                for (Interval interval : new IterableAdapter<Interval>(mergingIterator)) {
                    writer.write(interval);
                }
            }
            catch (IOException e) {
                if (!this.OUTPUT.renameTo(new File(this.OUTPUT.getAbsolutePath() + ".incomplete"))) {
                    this.OUTPUT.delete();
                }
                throw new PicardException("Trouble writing IntervalList. Renamed <OUTPUT> to <OUTPUT>.incomplete to avoid misuse.", e);
            }
        }
        return 0;
    }

    public static enum VARIANT_ID_TYPES {
        CONCAT_ALL,
        USE_FIRST;

    }
}

